% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSPlot.R
\name{TSPlot}
\alias{TSPlot}
\title{Plot simulation of two-dimensional stochastic differential equations}
\usage{
TSPlot(mat, deltat, dim = 1, xlim = "NULL", ylim = "NULL",
  x.lab = "time", dens = TRUE, lwd = 2, line.alpha = 130,
  zero.axes = TRUE, ...)
}
\arguments{
\item{mat}{a matrix output from \code{\link{TSTraj}}.}

\item{deltat}{numeric value indicating the frequency of stochastic perturbation, as \eqn{\Delta t}, used in the function to recaluculate axes if applicable.}

\item{dim}{dimensions of the plot; \code{dim = 1} to plot a timeseries with X and Y on the ordinate axis or \code{dim = 2} to plot the trjectories in state space (i.e., X and Y respectively on the abscissa and ordinate axes).}

\item{xlim}{numeric vectors of length 2, giving the x coordinate range. Default \code{= 'NULL'} automatically sizes plot window.}

\item{ylim}{numeric vectors of length 2, giving the y coordinate range. Default \code{= 'NULL'} automatically sizes plot window.}

\item{x.lab}{for \code{dim = 1}, allows user to specify the axis as "time" or "steps," with steps being \eqn{time \times \Delta t}}

\item{dens}{if \code{dens = TRUE}, plots a horizontal one-dimensional density plot adjacent to the timerseries.}

\item{lwd}{line width.  Defaults to 1.}

\item{line.alpha}{transparency of lines from 0--255.}

\item{zero.axes}{if TRUE, then axes plotted at \code{X = 0} and \code{Y = 0}.}

\item{...}{passes arguments to \code{\link{plot}}.}
}
\description{
This function plots the simulation of two-dimensional stochastic differential equations from \code{\link{TSTraj}}
}
\examples{
# First, the parameter values, as found in TSTraj
model.state <- c(x = 3, y = 3)
model.sigma <- 0.2
model.deltat <- 0.05
model.time <- 100

# Second, write out the deterministic skeleton of the equations to be simulated, 
# as found in TSTraj
#Example 1 from article
equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0 + x*x)"
equationy <- "((0.476*x*x*y)/(1 + x*x)) - 0.112590*y*y"

# Third, run it, as found in TSTraj
ModelOut <- TSTraj(y0 = model.state, time = model.time, deltat = model.deltat, 
	x.rhs = equationx, y.rhs = equationy, sigma = model.sigma)
# Fourth, plot it:
# in 1D
TSPlot(ModelOut, deltat = model.deltat, dim = 1)
# in 2D
TSPlot(ModelOut, deltat = model.deltat, dim = 2)
}
\keyword{plot}
\keyword{simulations}
\keyword{stochastic}

