% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.Design.R
\name{predictDesign}
\alias{predictDesign}
\title{Internal function to Calculate Predicted Competing Risks Probability.}
\usage{
predictDesign(
  fit,
  newdata = NULL,
  type = c("lp", "x", "data.frame", "terms", "adjto", "adjto.data.frame",
    "model.frame"),
  se.fit = FALSE,
  conf.int = FALSE,
  conf.type = c("mean", "individual"),
  incl.non.slopes = NULL,
  non.slopes = NULL,
  kint = 1,
  na.action = na.keep,
  expand.na = TRUE,
  center.terms = TRUE,
  ...
)
}
\arguments{
\item{fit}{a saved crr model fit crated by function}

\item{newdata}{data frame for prediction. Each row of the data
frame   contains values of covariates that are required in the crr
model. If   missing, the original data set that was used to
develop the crr model   will be used for prediction.}

\item{type}{type of output desired}

\item{se.fit}{return standard error}

\item{conf.int}{specify conf.int as a positive fraction to obtain upper and 
lower confidence intervals (e.g., `conf.int=0.95`).}

\item{conf.type}{specifies the type of confidence interval.}

\item{incl.non.slopes}{set to `TRUE` to include multiple intercepts, default is `NULL`}

\item{non.slopes}{a vector of multiple intercepts}

\item{kint}{a single integer specifying the number of the intercept to use 
in multiple-intercept models.}

\item{na.action}{Function to handle missing values in `newdata`.}

\item{expand.na}{set to `FALSE` to keep the naresid from having any effect}

\item{center.terms}{set to `FALSE` to suppress subtracting adjust-to values 
from columns of the design matrix before computing terms with `type="terms"`.}

\item{...}{ignored
\code{crr.fit}}
}
\value{
A vector with the length equal to the number of rows in the data
  frame, which was used to make prediction. Each element corresponds to a
  predicted failure probability at the expected time point.
}
\description{
Internal function to Calculate Predicted Competing Risks Probability.
}
\details{
Calculate predicted probabilities for a competing risks regression model
}
\seealso{
\code{\link[rms]{predictrms}},
}
