% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions_QF_ratio.R
\name{QF_ratio}
\alias{QF_ratio}
\alias{dQF_ratio}
\alias{pQF_ratio}
\alias{qQF_ratio}
\alias{rQF_ratio}
\title{Ratio of Positive Definite Quadratic Forms Distribution}
\usage{
dQF_ratio(x, obj)

pQF_ratio(q, obj)

qQF_ratio(p, obj, eps_quant = 1e-06, maxit_quant = 10000)

rQF_ratio(
  n,
  lambdas_num,
  lambdas_den,
  etas_num = rep(0, length(lambdas_num)),
  etas_den = rep(0, length(lambdas_den))
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{\code{MellinQF_ratio} object produced by the \code{\link{compute_MellinQF_ratio}} function.}

\item{p}{vector of probabilities.}

\item{eps_quant}{relative error for quantiles.}

\item{maxit_quant}{maximum number of Newton-Raphson iterations allowed to compute quantiles.}

\item{n}{number of observations.}

\item{lambdas_num}{vector of positive weights of the QF at the numerator.}

\item{lambdas_den}{vector of positive weights of the QF at the denominator}

\item{etas_num}{vector of non-centrality parameters of the QF at the numerator. Default all zeros.}

\item{etas_den}{vector of non-centrality parameters of the QF at the denominator Default all zeros.}
}
\value{
\code{dQF_ratio} provides the values of the density function at a quantile \code{x}.

\code{pQF_ratio} provides the cumulative distribution function at a quantile \code{q}.

\code{qQF_ratio} provides the quantile corresponding to a probability level \code{p}.

\code{rQF_ratio} provides a sample of \code{n} independent realizations the QFs ratio.
}
\description{
Density function, distribution function, quantile function and random generator for the ratio of positive definite QFs.
}
\details{
The CDF and PDF of the ratio of positive QFs are evaluated by numerical inversion of the Mellin transform.
The absolute error specified in \code{\link{compute_MellinQF_ratio}} is guaranteed for values of \code{q} and \code{x} inside \code{range_q}.
If the quantile is outside \code{range_q}, computations are carried out, but a warning is sent.

The function uses the Newton-Raphson algorithm to compute the ratio of QFs quantiles related to probabilities \code{p}.
}
\examples{
\donttest{
lambdas_QF_num <- c(rep(7, 6),rep(3, 2))
etas_QF_num <- c(rep(6, 6), rep(2, 2))
lambdas_QF_den <- c(0.6, 0.3, 0.1)
# Computation Mellin transform
eps <- 1e-7
rho <- 0.999
Mellin_ratio <- compute_MellinQF_ratio(lambdas_QF_num, lambdas_QF_den,
                                       etas_QF_num, eps = eps, rho = rho)
xs <- seq(Mellin_ratio$range_q[1], Mellin_ratio$range_q[2], l = 100)
# PDF
ds <- dQF_ratio(xs, Mellin_ratio)
plot(xs, ds, type="l")
# CDF
ps <- pQF_ratio(xs, Mellin_ratio)
plot(xs, ps, type="l")
# Quantile
qs <- qQF_ratio(ps, Mellin_ratio)
plot(ps, qs, type="l")
#Comparison computed quantiles vs real quantiles
plot((qs - xs) / xs, type = "l")

}

}
\seealso{
See \code{\link{compute_MellinQF_ratio}} for details on the Mellin computation.
}
