% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AND.R
\name{mleAND}
\alias{mleAND}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric normal distribution.}
\usage{
mleAND(y, alpha = NULL)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\mu,\phi,\alpha)} of the quantile-based asymmetric normal distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha)} in the asymmetric normal distribution
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019a).
}
\examples{
\donttest{
# Maximum likelihood estimation
y=rnorm(100)
mleAND(y)
mleAND(y,alpha=0.5)
}
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
