% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETF.R
\name{GTEF}
\alias{GTEF}
\alias{dGTEF}
\alias{pGTEF}
\alias{qGTEF}
\alias{rGTEF}
\title{Generalized tick-exponential family}
\usage{
dGTEF(y, eta, phi, alpha, p, g)

pGTEF(q, eta, phi, alpha, p, g)

qGTEF(beta, eta, phi, alpha, p, g, lower = -Inf, upper = Inf)

rGTEF(n, eta, phi, alpha, p, g, lower = -Inf, upper = Inf)
}
\arguments{
\item{y, q}{These are each a vector of quantiles.}

\item{eta}{This is the location parameter \eqn{\eta}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{p}{This is the shape parameter, which must be positive.}

\item{g}{This is the "link" function. The function \eqn{g} is to be differentiated. Therefore, \eqn{g} must be written as a function. For example, {g<-function(y)\{log(y)\}} for log link function.}

\item{beta}{This is a vector of probabilities.}

\item{lower}{This is the lower limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {-Inf}.}

\item{upper}{This is the upper limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {Inf}.}

\item{n}{This is the number of observations, which must be a positive integer that has length 1.}
}
\value{
\code{\link{dGTEF}} provides the density, \code{\link{pGTEF}} provides the cumulative distribution function, \code{\link{qGTEF}} provides the quantile function, and \code{\link{rGTEF}} generates a random sample from the generalized tick-exponential family of densities.
The length of the result is determined by \eqn{n} for \code{\link{rGTEF}}, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, cumulative distribution function, quantile function and random sample generation
from the generalized tick-exponential family (GTEF) of densities discusse in Gijbels et al. (2019b).
}
\examples{
# For identiy link function
y=rnorm(100)
g_id<-function(y){y}
dGTEF(y,eta=0,phi=1,alpha=0.5,p=2,g=g_id)

# cumulative distribution function
pGTEF(q=y,eta=10,phi=1,alpha=0.5,p=2,g=g_id)

# Quantile function
beta=c(0.25,0.5,0.75)
qGTEF(beta=beta,eta=10,phi=1,alpha=0.5,p=2,g=g_id)

# random sample generation
rGTEF(n=100,eta=10,phi=1,alpha=.5,p=2,g=g_id,lower = -Inf, upper = Inf)

# For log link function
y=rexp(100)
g_log<-function(y){log(y)}
dGTEF(y,eta=10,phi=1,alpha=0.5,p=2,g=g_log)

# cumulative distribution function
pGTEF(q=y,eta=10,phi=1,alpha=0.5,p=2,g=g_log)

# Quantile function
g_log<-function(y){log(y)}
#' beta=c(0.25,0.5,0.75)
qGTEF(beta=beta,eta=10,phi=1,alpha=0.5,p=2,g=g_log,lower = 0, upper = Inf)

# random sample generation
rGTEF(n=100,eta=10,phi=1,alpha=.5,p=2,g=g_log,lower = 0, upper = Inf)




}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
