% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATD.R
\name{LogLikATD}
\alias{LogLikATD}
\title{Log-likelihood function for the quantile-based asymmetric Student's-\eqn{t} distribution.}
\usage{
LogLikATD(y, mu, phi, alpha, nu)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{nu}{This is the degrees of freedom parameter \eqn{\nu}, which must be positive.}
}
\value{
\code{\link{LogLikATD}} provides the value of the Log-likelihood function of the quantile-based asymmetric Student's-\eqn{t} distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha,\nu)=\ln[L_n(\mu,\phi,\alpha,\nu)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha,\nu)} in
the quantile-based asymmetric Student's-\eqn{t} distribution by using the maximum likelihood estimation
are discussed in Gijbels et al. (2019a).
}
\examples{
# Example
y<-rnorm(100)
LogLikATD(y,mu=0,phi=1,alpha=0.5,nu=10)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
