% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q2q.R
\name{getqxt}
\alias{getqxt}
\title{getqxt: obtain the age-specific mortality surface}
\usage{
getqxt(Qxt, nag, t)
}
\arguments{
\item{Qxt}{A surface of Five-ages mortality rates which should be a numerical matrix containing mortality rates without age identification column and time identification row}

\item{nag}{The number of age groups}

\item{t}{The number of years}
}
\value{
qxt a matrix containing the age-specific mortality rates for age x in rows and for year t in columns

lxt a matrix containing the age evolution of survivorship for the year t

dxt a matrix containing the theoretical deaths occured at age x and year t

qxtl the age specific mortality rates interpolated using the Lagrange method for each year t

qxtk the age specific mortality rates interpolated using the Karup-king method for each year t

junct_ages a vector containing, for each year t, the ages where qxtk and qxtl have been joined
}
\description{
getqxt interpolate the age specific mortality rates for a set of period life tables
}
\examples{
getqxt(Qxt=LT, nag=17, t=38)
}
\author{
Farid FLICI
}
