% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProfoundData.R
\docType{package}
\name{ProfoundData-package}
\alias{ProfoundData-package}
\alias{ProfoundData}
\title{Overview of the functions in the ProfoundData package}
\description{
The ProfoundData R package provides functions to explore, visualize and get data from the PROFOUND database.  The development of the PROFOUND database and the ProfoundData R package was faciliated by COST Action FP1304 PROFOUND.

A brief description of the PROFOUND database is avalaible in the vignette 'PROFOUNDdatabase' (
you can open it by running this command: \code{vignette('PROFOUNDdatabase')}).

Note: before you can use the package, you need to download the database via \code{\link{downloadDatabase}} and
register the database location via \code{\link{setDB}}

Below is a list of the package's functions grouped by theme. See the package
vignette for more information and examples (\code{vignette('ProfoundData')}).
}
\section{I. Browse the database}{
 Functions to explore the database.
\itemize{
  \item \code{\link{browseData}} To check
  \itemize{
   \item  available sites
   \item  available datasets
   \item  available variables for a dataset
   \item  available datasets for a site
   \item  database version
   \item  metadata
   \item  policy
   \item  source
   \item  site description
   }
   \item \code{\link{summarizeData}} To obtain
    \itemize{
   \item  data overviews
   \item  data summaries
   }

}
}

\section{II. Extract data}{
 Functions to extract data. Data can be extracted for one site and one dataset at a time.
\itemize{
 \item \code{\link{getData}} To extract data
}
}

\section{III. Visualize data}{
 Functions to plot data from the database.
\itemize{
  \item \code{\link{plotData}} To plot data
}
}

\section{IV. Utilities}{
 Miscellanous
\itemize{
 \item \code{\link{downloadDatabase}} To download the database
 \item \code{\link{setDB}} To set the connection to the database
 \item \code{\link{getDB}} To retrieve the filepath to the database
  \item \code{\link{queryDB}} To pass self-defined queries
 \item \code{\link{reportDB}} To create a site-by-site report of the database
  \item \code{\link{writeSim2netCDF}} To write netCDF-files
}
}

\author{
Except where indicated otherwise, the functions in this package were written by Ramiro Silveyra Gonzalez, Christopher Reyer, Florian Hartig and Mahnken. Ramiro Silveyra Gonzalez was the main developer of the package. Florian Hartig is currently the maintainer.
}
\keyword{DB}
\keyword{Profound}
\keyword{package}
