% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incrExplor.R
\name{incrExplor}
\alias{incrExplor}
\title{Exploratory function for run-off triange increments}
\usage{
incrExplor(
  triangle,
  method = c("median", "mean", "max", "min"),
  out = 1,
  states = NULL,
  breaks = NULL,
  plotOption = FALSE,
  plotScale = 1
)
}
\arguments{
\item{triangle}{cumulative or incremental run-off triangle (an object of the
class \code{triangle} or \code{matrix}) specified in terms of a partially
observed (run-off triangle) or a fully observed (completed triangle) matrix.
Only the upper-left triangular part (run-off trangle) is used to provide the
output analysis of the incremental payments and the underlying Markov chain
setting options}

\item{method}{method form \code{c("median", "mean", "max", "min")} used to
summarize the run-off triangle increments within the given set of bins. Each
bin with the increments  is represented by a corresponding Markov state value
(obtained by the \code{method} choice with \code{median} being the DEFAULT option)}

\item{out}{integer value (or a vector of integers) to indicate which columns
of the run-off triangle should be excluded
from the exploratory analysis of the increments. By DEFAULT, the first
incremental payments---i.e., the first column of the run-off triangle---are
not considered (\code{out = 1}). No colums are exluded for \code{out = 0} and
the whole run-off triangle is analyzed by \code{incrExplor()}. To specify
multiple columns that should be excluded, one can use \code{out = c(1,2,3)}
which will exlude the first three columns from the exploratory analysis}

\item{states}{either an integer value to indicate an explicit number of the
Markov chain states to be used or  a vector of explicit Markov chain states
can be provided. The DEFAULT option (\code{states = NULL}) provides a fully
data-driven (automatic) definition of the Markov chain states as proposed
in Maciak, Mizera, and Pešta (2022)}

\item{breaks}{numeric vector of explicit (unique and monotonously increasing)
break points to define the bins for the run-off triangle increments.
If \code{states} is equal to some integer number (i.e., the explicit number
of the Markov chain states is requested by \code{states}) then the value of
\code{breaks} is ignored. If both \code{states} and \code{breaks} are specified
(i.e., numeric vectors are provided for both) then the set of states in
\code{states} must be given in a way that exactly one state value belongs to
exactly one bin defined by the break points specified by \code{breaks}}

\item{plotOption}{logical to indicate whether a graphical output supplementing
the empirical exploratory should be provided (\code{TRUE})
or not (\code{FALSE} -- DEFAULT)}

\item{plotScale}{positive scaling factor for adjusting the overall graphical
output (the DEFAULT value is \code{plotScale = 1})}
}
\value{
A list with the following elements:
\item{incrTriangle}{an object of the class \code{triangle} with the incremental
run-off triangle}
\item{triangleType}{type of the input run-off triangle provided for the input
object \code{triangle} (cumulative or incremental)}
\item{defaultStates}{the set of explicit states as used (by DEFAULT) by the
\code{mcReserve()} estimation algorithm}
\item{defaultBreaks}{the set of explicit breaks as used (by DEFAULT) by the
\code{mcReserve()} estimation algorithm}
\item{increments}{table with basic empirical characteristics of the increments
of the input run-off triangle (without the first origin payments---the values
in the first column of the run-off triangle). Two sets of increments are provided:
the raw incremental payments in the first row of the table and the standardized
increments (i.e., row incremental payments divided by the maximum payment within
the row (while not considering the columns specified by the \code{out} parameter)}
\item{userDefined}{a list with all information regarding the USER modified input
(numeric vector \code{increments} with the increments being analyzed; numeric
value in \code{outColumns} denoting the excluded columns in the run-off triangle;
\code{method} used to summarize the increments within the bins; numeric vector
with the resulting Markov chain states in \code{states} and the corresponding
numeric vector with the break points in \code{breaks} defining the bins for
the run-off triangle increments)}
}
\description{
The function takes a cumulative or incremental run-off triangle (partially or
completely observed) and provides some basic exploratory and graphical
inspection of the observed incremental payments. The function serves as
a useful tool for a user-based insight when manualy defining the states of
the Markov Chain that is used to drive the reserve prediction in the MACRAME
algorithm implemented in the function \code{mcReserve()}.
}
\examples{
data(CameronMutual) 

## default Markov Chain states with (roughly) equally occupied bins 
incrExplor(CameronMutual)

## five Markov Chain states (with roughly equally occupied bins)
incrExplor(CameronMutual, states = 5)

## explicitly defined breaks for five increment bins while the Markov states
## are obtained as medians of the increments within each bin
incrExplor(CameronMutual, breaks = c(20, 500, 1000, 2000))

## explicitly defined breaks for five bins and the Markov states
## are given as the maximum increments within each bin
incrExplor(CameronMutual, breaks = c(20, 500, 1000, 2000), method = "max")

## manually defined breaks for the bins and the corresponding states 
## exactly one state must be within each break
incrExplor(CameronMutual, breaks = c(20, 500, 1000), 
                          states = c(10, 250, 800, 1500))

}
\references{
Maciak, M., Mizera, I., and Pešta, M. (2022). Functional Profile
Techniques for Claims Reserving. ASTIN Bulletin, 52(2), 449-482. DOI:10.1017/asb.2022.4
}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=permuteReserve]{permuteReserve()}}
}
