% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.profileLadder.R
\name{as.profileLadder}
\alias{as.profileLadder}
\title{S3 Method class \code{profileLadder}}
\usage{
as.profileLadder(x)
}
\arguments{
\item{x}{an object of the class \code{matrix} or \code{triangle}}
}
\value{
an object of the class \code{profileLadder} which is a list with the
following elements:
\item{reserve}{basic summary of the run-off triangle and the true/estimated
reserve (if it is available otherwise \code{NA} values are provided instead)}
\item{method}{type of the printed triangle (either a run-off triangle itself
if no estimation method is applied or the completed triangle where the missing
fragments are imputed by one of the algorithm, PARALLAX, REACT, or MACRAME)}
\item{completed}{completed development profiles estimated by using one of the
estimation algorithm (i.e., PARALLAX, REACT, or MACRAME)---if applied---value
\code{NA} provided otherwise}
\item{inputTriangle}{standard (triangular shaped)  run-off triangle}
\item{trueComplete}{true completed development profiles of the run-off triangle
(if available) or  \code{NA} returned otherwise}
}
\description{
A function to make the work with the functional development profiles within
run-off triangles more easy and straightforward (particularly when vizualizing
the functional profiles in a plot)
}
\examples{
data(CameronMutual)
print(CameronMutual) 

x <- as.profileLadder(CameronMutual)

print(x)
plot(x)

}
\seealso{
\code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}, \code{\link[=permuteReserve]{permuteReserve()}},
\code{\link[=plot.profileLadder]{plot.profileLadder()}}
}
