% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covls.R
\name{varls}
\alias{varls}
\alias{corls}
\title{Procrustean Correlation, and Variance / Covariance Matrices.}
\usage{
varls(..., nrand = 100, p_adjust_method = "holm")

corls(..., nrand = 100, p_adjust_method = "holm")
}
\arguments{
\item{...}{the set of matrices or a \code{\link[ProcMod]{procmod_frame}}
object.}

\item{nrand}{number of randomisation used to estimate the mean
covariance observed between two random matrix.
If rand is \code{NULL} or equal to \code{0}, no correction
is estimated and the raw procrustean covariances are
estimated.}

\item{p_adjust_method}{the multiple test correction method used
to adjust p values. \code{p_adjust_method}
belongsone of the folowing values: \code{"holm"},
\code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"},
\code{"BH"}, \code{"BY"}, \code{"fdr"},  \code{"none"}.
The default is,set to \code{"holm"}.}
}
\value{
a \code{procmod_varls} object which corresponds to a numeric
             matrix annotated by several attributes.

             The following attribute is always added:

             - \code{nrand} an integer value indicating the number of
               randomisations used to estimate the mean of the random
               covariance.

             When \code{nrand} is greater than 0 a couple of attributes
             is added:

             - \code{rcovls} a numeric matrix containing the estimation
               of the mean of the random covariance.

             - \code{p.value} a numeric matrix containing the estimations
               of the p.values of tests checking that the observed
               covariance is larger than the mean of the random covariance.
               p.values are corrected for multiple tests according to the
               method specified by the \code{p_adjust_method} parameter.
}
\description{
\code{varls}, \code{corls} compute the procrustean
variance / covariance, or correlation matrices
between a set of real matrices and \code{\link[stats]{dist}} objects.
}
\details{
Procrustean covariance between two matrices X and Y, is defined as the sum
of the singular values of the X'Y matrix \insertCite{Gower:71:00,Lingoes:74:00}{ProcMod}.
Both the X and Y matrices must have the same number of rows.

The variances and covariances and correlations are corrected
to avoid over fitting \insertCite{Coissac-Eric:19:00}{ProcMod}.

The inputs must be numeric matrices or \code{\link[stats]{dist}} object.
The set of input matrices can be aggregated un a
\code{\link[ProcMod]{procmod_frame}}.

Before computing the coefficients, matrices are projected into an
orthogonal space using the \code{\link[ProcMod]{ortho}} function.

The denominator n - 1 is used which gives an unbiased estimator of the
(co)variance for i.i.d. observations.
}
\examples{
# Build Three matrices of 3 rows.
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the variance covariance matrix
varls(A = A, B = B, C = C)

data = procmod_frame(A = A, B = B, C = C)
varls(data)

# Computes the correlation matrix
corls(data, nrand = 100)

}
\references{
{
 \insertRef{Gower:71:00}{ProcMod}

 \insertRef{Lingoes:74:00}{ProcMod}

 \insertRef{Coissac-Eric:19:00}{ProcMod}
}
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
