% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{nybble}
\alias{nybble}
\alias{loNybble}
\alias{hiNybble}
\title{Get the high or low nybble of a raw value}
\usage{
nybble(raw_dat, which = c("low", "high"))

loNybble(raw_dat)

hiNybble(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of class \code{raw} from which the high or low nybble value
needs to be extracted.}

\item{which}{A character string indicating whether the high or low nybble should
be returnd. It should either be "\code{low}" (default) or "\code{high}".}
}
\value{
A vector of the same length as \code{raw_dat} holding integer values.
}
\description{
Get the high or low nybble of a raw value and return as integer value [0,15].
}
\details{
A \code{raw} is basically a byte, composed of 8 bits (zeros and ones).
A nybble is a 4 bit value. Hence, a raw value (or byte) is composed of
two nybbles. The leftmost nybble of a raw value is refered to as the
high nybble, the rightmost nybble is referred to as the low nybble.
These functions return either the high or low nybbles of raw data as integer
values [0,15].
As ProTracker stores some information as nybbles this function can be
used to retrieve this info.
}
\examples{
## this will return 0x0f:
hiNybble(as.raw(0xf3))

## which is the same as:
nybble(as.raw(0xf3), "high")

## this will return 0x03:
loNybble(as.raw(0xf3))

## which is the same as:
nybble(as.raw(0xf3), "low")
}
\seealso{
Other nybble.functions: \code{\link{nybbleToSignedInt}},
  \code{\link{signedIntToNybble}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{nybbleToSignedInt}},
  \code{\link{rawToCharNull}}, \code{\link{rawToPTModule}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}

Other integer.operations: \code{\link{nybbleToSignedInt}},
  \code{\link{rawToSignedInt}},
  \code{\link{rawToUnsignedInt}},
  \code{\link{signedIntToNybble}},
  \code{\link{signedIntToRaw}},
  \code{\link{unsignedIntToRaw}}, \code{\link{waveform}}
}
\author{
Pepijn de Vries
}
