% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03PTTrack.r
\docType{class}
\name{PTTrack-class}
\alias{PTTrack}
\alias{PTTrack-class}
\title{The PTTrack class}
\description{
The four audio channels of the Commodore Amiga are represented as tracks
(the \code{PTTrack} class) in a \code{\link{PTPattern}}.
}
\details{
The Commodore Amiga original chipset supported four audio channels. Meaning
that audio could be played simultaneously and independently on each of these
channels. Two channels (2 and 3) were hardware-mixed fully to the left stereo
outputs and the other two (1 and 4) fully to the right stereo outputs.

This class represents such a single channel, reffered to as a track. A \code{\link{PTPattern}} is
composed of four such channels. As a ProTracker pattern consists of 64 rows,
a \code{PTTrack} object is also (implicitly) composed of 64
\code{\link{PTCell}} objects.

Use the \code{\link{PTTrack-method}} to construct or coerce objects to a
\code{PTTrack-class} object, or to replace such an object.
}
\section{Slots}{

\describe{
\item{\code{data}}{A \code{matrix} (64 rows, 4 columns) of class "\code{raw}".
Each row implicetely represents a \code{\link{PTCell}} object, where
the raw data is formatted as specified at the \code{\link{PTCell-class}}
documentation. Use the \code{\link{PTCell-method}} to make an element of
a \code{PTTrack} object explictly of class \code{\link{PTCell}}.
Row numbers correspond with the row numbers of \code{\link{PTPattern}}
objects.}
}}
\examples{
data("mod.intro")

## Get track number 2 from pattern
## number 1 of mod.intro:
chan1 <- PTTrack(mod.intro, 2, 1)

## Create a blank track:
chan2 <- new("PTTrack")

## Get two more tracks:
chan3 <- PTTrack(mod.intro, 1, 2)
chan4 <- PTTrack(mod.intro, 4, 3)

## combine the four tracks in a
## new PTPattern:
patt <- PTPattern(cbind(
  as.character(chan1),
  as.character(chan2),
  as.character(chan3),
  as.character(chan4)
))
}
\author{
Pepijn de Vries
}

