% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gen.data}
\alias{gen.data}
\title{Generate simulation data}
\usage{
gen.data(n = 100, p = 50, s = 10, beta.min = 1, beta.max = 5, rho = 0, nu = 2)
}
\arguments{
\item{n}{The number of observations}

\item{p}{The number of explanatory variables}

\item{s}{The number of true signals}

\item{beta.min}{The smallest effect size in absolute value}

\item{beta.max}{The largest effect size in absolute value}

\item{rho}{The autocorrelation level}

\item{nu}{The signal to noise ratio}
}
\value{
A list of following components:
\describe{
\item{X}{The generated explanatory variable matrix}
\item{Y}{A vector of outcome}
\item{index}{The indices of true signals }
}
}
\description{
This function can be used to generate autoregressive simulation data
}
\examples{
# generate data
data <- gen.data()

# extract x
x <- data[[1]]

# extract y
y <- data[[2]]

# extract the indices of true signals
index <- data[[3]]
}
