% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FAST_single}
\alias{FAST_single}
\title{Fit FAST model for single-section SRT data}
\usage{
FAST_single(
  seu,
  Adj_sp,
  q = 15,
  fit.model = c("poisson", "gaussian"),
  slot = "data",
  assay = NULL,
  reduction.name = "fast",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{seu}{a Seurat object.}

\item{Adj_sp}{a sparse matrix, specify the adjacency matrix among spots.}

\item{q}{an optional integer, specify the number of low-dimensional embeddings to extract in FAST. Larger q means more information extracted.}

\item{fit.model}{an optional string, specify the version of FAST to be fitted. The Gaussian version models the log-count matrices while the Poisson verions models the count matrices; default as possion model.}

\item{slot}{an optional string, specify the slot in Seurat object as the input of FAST model, default as `data`.}

\item{assay}{an optional string, specify the assay in Seurat object, default as `NULL` that means the default assay in Seurat object.}

\item{reduction.name}{an optional string, specify the reduction name for the fast embedding, default as `fast`.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{...}{other arguments passed to \code{\link{FAST_run}}.}
}
\value{
return a list including the parameters set in the arguments.
}
\description{
Fit FAST model for single-section SRT data.
}
\seealso{
\code{\link{FAST_run}}
}
