% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comparing_indices.R
\name{compare_final_indices}
\alias{compare_final_indices}
\title{A general function for graphical comparison of price indices}
\usage{
compare_final_indices(
  finalindices = list(),
  names = c(),
  date_breaks = "1 month"
)
}
\arguments{
\item{finalindices}{A list of data frames with previously calculated price indices. Each data frame must consist of two columns, i.e. the first column must includes dates limited to the year and month (e.g.: "2020-04") and the second column must indicate price index values for corresponding dates. The above-mentioned single data frame may be created manually in the previous step or it may be a result of functions: \code{price_index} or \code{final_index}. All considered data frames must have an identical number of rows.}

\item{names}{A vector of character strings describing names of presented indices.}

\item{date_breaks}{A string giving the distance between breaks on the X axis like "1 month" (default value) or "4 months".}
}
\value{
This function returns a figure with plots of previously calculated price indices. It allows for graphical comparison of price index values which were previously calculated and now are provided as data frames (see \code{finalindices} parameter).
}
\description{
This function returns a figure with plots of previously calculated price indices.
}
\examples{
## Caluclating two indices by using two different package functions:
\donttest{index1<-final_index(datasets=list(milk), start="2018-12", 
end="2019-12",formula="walsh",interval=TRUE)}
\donttest{index2<-price_index(milk,start="2018-12", end="2019-12",
formula="geks",interval=TRUE)}
## Graphical comparison of these two indices 
\donttest{compare_final_indices(finalindices=list(index1,index2), 
names=c("Walsh index", "GEKS index"))}
}
