% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sales}
\alias{sales}
\title{Providing values of product sales}
\usage{
sales(data, period, set = c(), shares = FALSE, hist = FALSE)
}
\arguments{
\item{data}{The user's data frame. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities} (as positive numeric) and \code{prodID} (as numeric, factor or character) with unique product IDs.}

\item{period}{The time period (as character) limited to the year and month, e.g. "2019-03".}

\item{set}{The set of unique product IDs to be used for determining product sales values (see also \code{\link{data_matching}}). If the \code{set} is empty, then the function returns sale values of all products being available in \code{period}.}

\item{shares}{A logical parameter indicating whether the function is to return shares of product sales.}

\item{hist}{A logical parameter indicating whether the function is to return histogram of product sales.}
}
\value{
The function analyzes the user's data frame and returns values of sales of products with given IDs and being sold in time period indicated by the \code{period} parameter.
}
\description{
The function returns values of sales of products with given IDs.
}
\examples{
\donttest{sales(milk, period="2019-06", shares=TRUE, hist=TRUE)}
sales(milk, period="2019-12",set=unique(milk$prodID)[1])
}
