% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{lm.ps.MCML}
\alias{lm.ps.MCML}
\title{Monte Carlo Maximum Likelihood estimation of the geostatistical linear model with preferentially sampled locations}
\usage{
lm.ps.MCML(
  formula.response,
  formula.log.intensity = ~1,
  coords,
  which.is.preferential = NULL,
  data.response,
  data.intensity = NULL,
  par0,
  control.mcmc,
  kappa1,
  kappa2,
  mesh,
  grid.intensity,
  start.par = NULL,
  method = "nlminb",
  messages = TRUE,
  plot.correlogram = TRUE
)
}
\arguments{
\item{formula.response}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the sub-model for the response variable.}

\item{formula.log.intensity}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the log-Gaussian Cox process sub-model.}

\item{coords}{an object of class \code{\link{formula}} indicating the spatial coordinates in the data.}

\item{which.is.preferential}{a vector of 0 and 1, where 1 indicates a location in the data from a prefential sampling scheme and 0 from a non-preferential.
This option is used to fit a model with a mix of preferentally and non-preferentiall sampled locations. For more, details on the model structure see the 'Details' section.}

\item{data.response}{a data frame containing the variables in the sub-model of the response variable.}

\item{data.intensity}{a data frame containing the variables in the log-Gaussian Coz process sub-model. This data frame must be provided only when explanatory variables are used in the
log-Gaussian Cox process model. Each row in the data frame must correspond to a point in the grid provided through the argument 'grid.intensity'. Deafult is \code{data.intensity=NULL},
which corresponds to a model with only the intercept.}

\item{par0}{an object of class 'coef.PrevMap.ps'. This argument is used to define the parameters of the importance sampling distribution used in the MCML algorithm.
The input of this argument must be defined using the \code{\link{set.par.ps}} function.}

\item{control.mcmc}{output from \code{\link{control.mcmc.MCML}} which defined the control parameters of the Monte Carlo Markv chain algorithm.}

\item{kappa1}{fixed value for the shape parameter of the Matern covariance function of the spatial process of the sampling intensity (currently only \code{kappa1=1} is implemented).}

\item{kappa2}{fixed value for the shape parameter of the Matern covariance function of the spatial process of the response variable.}

\item{mesh}{an object obtained as result of a call to the function \code{inla.mesh.2d}.}

\item{grid.intensity}{a regular grid covering the geographical region of interest, used to approximate the density function of the log-Gaussian Cox process.}

\item{start.par}{starting value of the optimization algorithm. This is an object of class 'coef.PrevMap.ps' and must be defined using the function \code{\link{set.par.ps}}.
Default is \code{start.cov.pars=NULL}, so that the starting values are set automatically.}

\item{method}{method of optimization. If \code{method="BFGS"} then the \code{\link{maxBFGS}} function is used; otherwise \code{method="nlminb"} to use the \code{\link{nlminb}} function. Default is \code{method="BFGS"}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{plot.correlogram}{logical; if \code{plot.correlogram=TRUE} the autocorrelation plot of the samples of the random effect is displayed after completion of conditional simulation. Default is \code{plot.correlogram=TRUE}.}
}
\value{
An object of class "PrevMap.ps".
The function \code{\link{summary.PrevMap.ps}} is used to print a summary of the fitted model.
The object is a list with the following components:

\code{estimate}: estimates of the model parameters; use the function \code{\link{coef.PrevMap.ps}} to obtain estimates of covariance parameters on the original scale.

\code{covariance}: covariance matrix of the MCML estimates.

\code{log.lik}: maximum value of the approximated log-likelihood.

\code{y}: observed values of the response variable. If \code{which.is.preferential} has been provided, then \code{y} is a list with components
\code{y$preferential}, for the data with prefentially sampled locations, and \code{y$non.preferential}, for the remiaining.

\code{D.response}: matrix of covariates used to model the mean component of the response variable. If \code{which.is.preferential} has been provided, then \code{D.response} is a list with components
\code{D.response$preferential}, for the data with prefentially sampled locations, and \code{D.response$non.preferential}, for the remiaining.

\code{D.intensity}: matrix of covariates used to model the mean component of log-intensity of the log-Gaussian Cox process.

\code{grid.intensity}: grid of locations used to approximate the intractable integral of the log-Gaussian Cox process model.

\code{coords}: matrix of the observed sampling locations. If \code{which.is.preferential} has been provided, then \code{coords} is a list with components
\code{y$preferential}, for the data with prefentially sampled locations, and \code{y$non.preferential}, for the remiaining.

\code{method}: method of optimization used.

\code{ID.coords}: set of ID values defined through the argument \code{ID.coords}.

\code{kappa.response}: fixed value of the shape parameter of the Matern covariance function used to model the spatial process associated with the response variable.

\code{mesh}: the mesh used in the SPDE approximation.

\code{samples}: matrix of the random effects samples from the importance sampling distribution used to approximate the likelihood function.

\code{call}: the matched call.
}
\description{
This function performs Monte Carlo maximum likelihood (MCML) estimation for a geostatistical linear model with preferentially sampled locations.
For more details on the model, see below.
}
\details{
This function performs parameter estimation for a geostatistical linear model with preferentially sampled locations. Let \eqn{S_{1}} and \eqn{S_{2}} denote two independent, stationary and isotropic Gaussian processes.
The overall model consists of two sub-models: the log-Gaussian Cox process model for the preferentially sampled locations, say \eqn{X};
the model for the response variable, say \eqn{Y}. The model assumes that
\deqn{[X, Y, S_1, S_2] = [S_1][S_2] [X | S_1] [Y | X, S_1, S_2],}
where \eqn{[.]} denotes 'the distribution of .'.
Each of the two submodels has an associated linear predictor.
Let \eqn{\Lambda(x)} denote the intensity of the Poisson process \eqn{X}, continionally on \eqn{S_1}. Then
\deqn{\log\{\Lambda(x)\} = d(x)'\alpha + S_1},
where \eqn{d(x)} is vector of explanatory variables with regression coefficient \eqn{\alpha}. This linear predictor is defined through the argument \code{formula.log.intensity}.
The density of \eqn{[X | S_1]} is given by
\deqn{\frac{\Lambda(x)}{\int_{A} \Lambda(u) du}},
where \eqn{A} is the region of interest. The integral at the denominator is intractable and is then approximated using a quadrature procedure.
The regular grid covering \eqn{A}, used for the quadrature, must be provided through the argument \code{grid.intensity}.
Conditionally on \eqn{X}, \eqn{S_1} and \eqn{S_2}, the response variable model is given by \deqn{Y = d(x)'\beta + S_2 + \gamma S_1,}
where \eqn{\beta} is another vector of regression coefficients and \eqn{\gamma} is the preferentiality parameter. If \eqn{\gamma=0} then we recover the standard geostatistical model.
More details on the fitting procedure can be found in Diggle and Giorgi (2016).

\bold{When the data have a mix of preferentially and non-preferentially sampled locations.}
In some cases the set of locations may consist of a sub-set which is preferentially sampled, \eqn{X}, and a standard
non-prefential sample, \eqn{X^*}. Let \eqn{Y} and \eqn{Y^*} denote the measurments at locations \eqn{X} and \eqn{X^*}.
In the current implementation, the model has the following form
\deqn{[X, X^*, Y, Y^*, S_1, S_2, S_2^*] = [S_1][S_2][S_2^*] [X | S_1] [Y | X, S_1, S_2] [X^*] [Y^*|X^*, S_2^*],}
where \eqn{S_2} and \eqn{S_2^*} are two independent Gaussian process but with shared parameters, associated with \eqn{Y} and \eqn{Y^*}, respectively.
The linear predictor for \eqn{Y} is the same as above. The measurements \eqn{Y^*}, instead, have linear predicotr
\deqn{Y^* = d(x)'\beta + S_2^*,}
where \eqn{\beta^*} is vector of regression coefficients, different from \eqn{\beta}. The linear predictor for \eqn{Y} and \eqn{Y^*} is specified though \code{formula.response}.
For example, \code{response ~ x | x + z} defines a linear predictor for \eqn{Y} with one explanatory variable \code{x} and a linear predictor for \eqn{Y^*} with two explanatory variables
\code{x} and \code{z}. An example on the application of this model is given in Diggle and Giorgi (2016).
}
\references{
Diggle, P.J., Giorgi, E. (2019). \emph{Model-based Geostatistics for Global Public Health.} CRC/Chapman & Hall.

Giorgi, E., Diggle, P.J. (2017). \emph{PrevMap: an R package for prevalence mapping.} Journal of Statistical Software. 78(8), 1-29. doi: 10.18637/jss.v078.i08

Diggle, P.J., Giorgi, E. (2017). \emph{Preferential sampling of exposures levels.} In: Handbook of Environmental and Ecological Statistics. Chapman & Hall.

Diggle, P.J., Menezes, R. and Su, T.-L. (2010). \emph{Geostatistical analysis under preferential sampling (with Discussion).} Applied Statistics, 59, 191-232.

Lindgren, F., Havard, R., Lindstrom, J. (2011). \emph{An explicit link between Gaussian fields and Gaussian Markov random fields: the stochastic partial differential equation approach (with discussion).}
Journal of the Royal Statistical Society, Series B, 73, 423--498.

Pati, D., Reich, B. J., and Dunson, D. B. (2011). \emph{Bayesian geostatistical modelling with informative sampling locations.} Biometrika, 98, 35-48.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}
}
