% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogrampn.R
\name{pn.ICred}
\alias{pn.ICred}
\title{Credibility interval for alpha (PN distribution)}
\usage{
 pn.ICred(x, p, prior="Jeffreys", shape_0=NULL, rate_0 = NULL)

}
\arguments{
\item{x}{the response vector}
\item{p}{credibility level}
\item{prior}{the prior distribution of power parameter: "Jeffreys" (default), "Uniform" and "Gamma"}
\item{shape_0, rate_0}{shape and rate hyperparameters of the gamma distribution.}
}

\description{
Credibility interval for the power parameter of PN distribution
}


\references{

Agamez-Montavo, G. (2017). Modelos de mistura finita usando a classe de distribuicoes alpha potencia.
  \emph{Thesis (Doctoral)}, University of Sao Paulo.

}



\examples{

x <- rpn(100, 25)

pn.ICred(x, 0.95)

pn.ICred(x, 0.95, prior = 'Uniform')

pn.ICred(x, 0.95, prior = 'Gamma', 1/100, 1/100)

}
