% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.efficient.frontier.R
\name{chart.EfficientFrontierCompare}
\alias{chart.EfficientFrontierCompare}
\title{Overlay the efficient frontiers of different minRisk portfolio objects on a single plot.}
\usage{
chart.EfficientFrontierCompare(
  R,
  portfolio,
  risk_type,
  n.portfolios = 25,
  match.col = c("StdDev", "ES"),
  guideline = NULL,
  main = "Efficient Frontiers",
  plot_type = "l",
  cex.axis = 0.5,
  element.color = "darkgray",
  legend.loc = NULL,
  legend.labels = NULL,
  cex.legend = 0.8,
  xlim = NULL,
  ylim = NULL,
  ...,
  chart.assets = TRUE,
  labels.assets = TRUE,
  pch.assets = 21,
  cex.assets = 0.8,
  col = NULL,
  lty = NULL,
  lwd = NULL
)
}
\arguments{
\item{R}{an xts object of asset returns}

\item{portfolio}{same constrained portfolio created by \code{\link{portfolio.spec}}}

\item{risk_type}{type of risk that you want to compare}

\item{n.portfolios}{number of portfolios to extract along the efficient frontier.
This is only used for objects of class \code{optimize.portfolio}}

\item{match.col}{string name of column to use for portfolio object.
Must match the name of an objective.}

\item{guideline}{show the risk difference and mean difference between efficient frontiers}

\item{main}{title used in the plot.}

\item{plot_type}{define the plot_type, default is "l"}

\item{cex.axis}{the magnification to be used for sizing the axis text relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{element.color}{provides the color for drawing less-important chart elements, such as the box lines, axis lines, etc.}

\item{legend.loc}{location of the legend; NULL, "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center".}

\item{legend.labels}{character vector to use for the legend labels.}

\item{cex.legend}{The magnification to be used for sizing the legend relative to the current setting of 'cex', similar to \code{\link{plot}}.}

\item{xlim}{set the x-axis limit, same as in \code{\link{plot}}.}

\item{ylim}{set the y-axis limit, same as in \code{\link{plot}}.}

\item{\dots}{passthrough parameters to \code{\link{plot}}.}

\item{chart.assets}{TRUE/FALSE to include the assets.}

\item{labels.assets}{TRUE/FALSE to include the asset names in the plot.}

\item{pch.assets}{plotting character of the assets, same as in \code{\link{plot}}.}

\item{cex.assets}{A numerical value giving the amount by which the asset points and labels should be magnified relative to the default.}

\item{col}{vector of colors with length equal to the number of portfolios in \code{portfolio_list}. Add two more to customize guideline color.}

\item{lty}{vector of line types with length equal to the number of portfolios in \code{portfolio_list}. Add two more to customize guideline type.}

\item{lwd}{vector of line widths with length equal to the number of portfolios in \code{portfolio_list}. Add two more to customize guideline width.}
}
\description{
Overlay the efficient frontiers of different minRisk portfolio objects on a single plot.
}
\author{
Xinran Zhao
}
