% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wassermann.r
\name{wassermann}
\alias{wassermann}
\title{Partial Mantel tests on costdistance matrices}
\usage{
wassermann(gen.mat, cost.mats, eucl.mat = NULL, plot = TRUE, nperm = 999)
}
\arguments{
\item{gen.mat}{pairwise genetic distance matrix}

\item{cost.mats}{pairwise cost distance matrix}

\item{eucl.mat}{pairwise Eukclidean distance matrix}

\item{plot}{switch for control plots of the partial mantel test}

\item{nperm}{number of permutations for the partial mantel test}
}
\value{
A table with the results of the partial mantel test. Using plot=TRUE
results in diagnostic plots for the partial mantel tests.
}
\description{
This function implements the Causal modelling approach as suggested by
Wassermann et al. 2010 and Cushman et al. 2010. It tests for the effect of
landscape features using a cost distance matrix on the genetic structure of
subpopulation/individuals.
}
\details{
see \code{\link{landgenreport}}
}
\examples{

\donttest{
library(raster)
fric.raster <- readRDS(system.file("extdata","fric.raster.rdata", package="PopGenReport"))
glc <- genleastcost(landgen, fric.raster, "D", NN=8)
wassermann(eucl.mat = glc$eucl.mat, cost.mats = glc$cost.mats, gen.mat = glc$gen.mat)
}
}
\references{
Wassermann, T.N., Cushman, S. A., Schwartz, M. K. and Wallin, D.
O. (2010). Spatial scaling and multi-model inference in landscape genetics:
Martes americana in northern Idaho. Landscape Ecology, 25(10), 1601-1612.
}
\seealso{
\code{\link{popgenreport}}, \code{\link{genleastcost}},
\code{\link{landgenreport}}, \code{\link{lgrMMRR}}
}
\author{
Bernd Gruber (bernd.gruber@canberra.edu.au)
}
