% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{hapdos2mrkdos}
\alias{hapdos2mrkdos}
\title{calculate the marker dosages resulting from haplotype dosage
combinations}
\usage{
hapdos2mrkdos(hapdos, allhap)
}
\arguments{
\item{hapdos}{a matrix with one column per combination of haplotypes
and one row for each possible haplotype (corresponding to the rows of allhap)
with dosage of the haplotypes in each combination. A vector is interpreted
as a one-column matrix; all columns must sum to ploidy. The rownames of
the matrix (or names of the vector) must contain the haplotype numbers}

\item{allhap}{a matrix as returned by allHaplotypes}
}
\value{
a matrix with columns corresponding to the columns of hapdos
and one row for each marker, with the dosages of each marker in each combination;
colnames are the mrkdids (marker dosage IDs), rownames are the marker names taken
from allhap
}
\description{
calculate the marker dosages resulting from haplotype dosage
combinations
}
\details{
if hapdos contains NA values, all values in the corresponding
column of the result will also be NA
}
\examples{
# get a matrix of all haplotypes with the 3 specified markers:
ah <- allHaplotypes(mrknames=c("mrkA", "mrkB", "mrkC"))
# specify haplotype dosages of 4 tetraploid individuals,
# only the 3 occurring haplotypes (1, 5 and 6) are given:
haplodosg <-
 matrix(c(1,2,1, 4,0,0, 0,4,0, 0,0,4), nrow=3,
        dimnames=list(paste0("demohap_", c(1,5,6)), paste0("indiv", 1:4)))
# calculate the corresponding marker (SNP) dosages:
hapdos2mrkdos(hapdos=haplodosg, allhap=ah)
}
