% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{compareHapMrkDosages}
\alias{compareHapMrkDosages}
\title{compare haplotyping results with observed markers dosages}
\usage{
compareHapMrkDosages(mrkDosage, hapresults)
}
\arguments{
\item{mrkDosage}{a data.frame or matrix with the marker dosages, in
the format of inferHaplotypes()}

\item{hapresults}{a list as returned by inferHaplotypes,
with one item (itself a list) per haploblock with at least a matrix hapdos
and a character vector markers. All markers in all haploblocks must also
occur in mrkDosages, and all individuals in the hapdos matrices must also
occur in mrkDosages}
}
\value{
a 3-D array with dimensions haploblock, individual, and chkresult:
mrkNA (ALL markers in the haploblock have missing data for the individual),
hapNA (the haplotype dosages do not sum to ploidy and/or are missing),
match (TRUE if the non-missing marker dosages match the haplotype dosages,
FALSE is there is a conflict, NA if mrkNA and/or hapNA are TRUE)
Each element is itself a list with elements:
}
\description{
compare haplotyping results with observed markers dosages
}
\examples{
data(PolyHaplotyper_small)
chmd <- compareHapMrkDosages(mrkDosage=phdos, hapresults=phresults)
# show results for first haploblock, first 8 individuals:
chmd[1, 1:8,]
}
