% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson-Multinomial_functions.R
\name{dpmd}
\alias{dpmd}
\title{Probability Mass Function of Poisson-Multinomial Distribution}
\usage{
dpmd(pmat, xmat = NULL, method = "DFT-CF", B = 1000)
}
\arguments{
\item{pmat}{An \eqn{\rm n \times m} success probability matrix. Here, \eqn{\rm n} is the number of independent trials, and
\eqn{\rm m} is the number of categories.
Each row of pmat describes the success probability for the corresponding
trial and it should add up to 1.}

\item{xmat}{A matrix with \eqn{\rm m} columns that specifies where the pmf is to be computed. Each row of the matrix should has the form
\eqn{\rm x = (x_{1}, \ldots, x_{m})} which is used for computing 
\eqn{\rm P(X_{1}=x_{1}, \ldots, X_{m} = x_{m})}, the values of \eqn{\rm x} should sum up to \eqn{\rm n}. It can be a vector of length \eqn{\rm m}. If \code{xmat} is \code{NULL}, the pmf at all probability mass points will be computed.}

\item{method}{Character string stands for the method selected by users to 
compute the cdf. The method can only be one of 
the following three: 
\code{"DFT-CF"},
\code{"NA"},
\code{"SIM"}.}

\item{B}{Number of repeats used in the simulation method. It is ignored for methods other than
the \code{"SIM"} method.}
}
\value{
For a given \code{xmat}, \code{dpmd} returns the pmf at points specified by \code{xmat}. 

If \code{xmat} is \code{NULL}, all probability mass points for the distribution specified by the success probability matrix \code{pmat} will be computed, and the results are
stored and outputted in a multi-dimensional array, denoted by \code{res}. Note the dimension of 
\code{pmat} is \eqn{\rm n \times m}, thus \code{res} will be an \eqn{\rm (n+1)^{(m-1)}} array. Then 
the value of the pmf \eqn{\rm P(X_{1}=x_{1}, \ldots, X_{m} = x_{m})} can be extracted as \eqn{\rm res[x_{1}+1, \ldots, x_{m-1}+1]}.

For example, for the \code{pmat} matrix in the example section, the array element \code{res[1,2,1]=0.90} gives 
the value of the pmf \eqn{\rm P(X_{1}=0, X_{2}=1, X_{3}=0, X_{4}=2)=0.90}.
}
\description{
Computes the pmf of Poisson-Multinomial distribution (PMD), 
specified by the success probability matrix, using various methods. This function 
is capable of computing all probability mass points as well as
of pmf at certain point(s).
}
\details{
Consider \eqn{\rm n} independent trials and each trial leads to a success outcome for exactly one of the \eqn{\rm m} categories. 
Each category has varying success probabilities from different trials. The Poisson multinomial distribution (PMD) gives the probability 
of any particular combination of numbers of successes for the \eqn{\rm m} categories. 
The success probabilities form an \eqn{\rm n \times m} matrix, which is called the success probability matrix and denoted by \code{pmat}.  
For the methods we applied in \code{dpmd}, \code{"DFT-CF"} is an exact method that computes all probability mass points of the distribution,
using multi-dimensional FFT algorithm. When the dimension of \code{pmat} increases, the computation burden of \code{"DFT-CF"} may challenge the capability 
of a computer because the method automatically computes all probability mass points regardless of the input of \code{xmat}.

\code{"SIM"} is a simulation method that generates random samples from the distribution, and uses relative frequency to estimate the pmf. Note that the accuracy and running time will be affected by user choice of \code{B}. 
Usually \code{B}=1e5 or 1e6 will be accurate enough. Increasing \code{B} to larger than 1e8 will heavily increase the
computational burden of the computer. 

\code{"NA"} is an approximation method that uses a multivariate normal distribution to approximate 
the pmf at the points specified in \code{xmat}. This method requires an input of \code{xmat}.

Notice if \code{xmat} is not specified then it will be set as \code{NULL}. In this case, \code{dpmd} will 
compute the entire pmf if the chosen method is \code{"DFT-CF"} or \code{"SIM"}. 
If \code{xmat} is provided, only the pmf at the points specified 
by \code{xmat} will be outputted.
}
\examples{
pp <- matrix(c(.1, .1, .1, .7, .1, .3, .3, .3, .5, .2, .1, .2), nrow = 3, byrow = TRUE)
x <- c(0,0,1,2) 
x1 <- matrix(c(0,0,1,2,2,1,0,0),nrow=2,byrow=TRUE)

dpmd(pmat = pp)
dpmd(pmat = pp, xmat = x1)
dpmd(pmat = pp, xmat = x)

dpmd(pmat = pp, xmat = x, method = "NA" )
dpmd(pmat = pp, xmat = x1, method = "NA" )

dpmd(pmat = pp, method = "SIM", B = 1e3)
dpmd(pmat = pp, xmat = x, method = "SIM", B = 1e3)
dpmd(pmat = pp, xmat = x1, method = "SIM", B = 1e3)

}
\references{
Lin, Z., Wang, Y., and Hong, Y. (2022). The Poisson Multinomial Distribution and Its Applications in Voting Theory, Ecological Inference, and Machine Learning, arXiv:2201.04237.
}
