% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_plot.R
\name{dot_plot}
\alias{dot_plot}
\title{Function to cutomise the Dot Plot of CellPhoneDB analysis results.}
\usage{
dot_plot(
  vgm.input,
  selected.rows,
  selected.columns,
  threshold.type,
  threshold.value,
  project.name,
  filename,
  width,
  height,
  text.size,
  return.vector,
  platypus.version
)
}
\arguments{
\item{vgm.input}{Output of the VDJ_GEX_matrix function. Mandatory. Object where to save the dotplot.}

\item{selected.rows}{Strings vector. Defaults to NULL. Vector of rows to plot (interacting genes pair), one per line.}

\item{selected.columns}{Strings vector. Defaults to  NULL. Vector of columns (interacting groups) to plot, one per line}

\item{threshold.type}{Character vector. Defaults to NULL. Possible arguments: "pvalue", "log2means", "pvalue_topn", "log2means_topn". Which thresholding system the user wants to use.}

\item{threshold.value}{Numerical. Defaults to NULL. Value below/above (depending on whether it's pvalue or log2means) which genes to plot are selected.}

\item{project.name}{Character vector. Defaults to NULL. Subfolder where to find the output of the CellPhoneDB analysis and where to save the dot_plot output plot.}

\item{filename}{Character vector. Defaults to "selection_plot.pdf". Name of the file where the dot_plot output plot will be saved.}

\item{width}{Numerical. Defaults to 8. Width of the plot.}

\item{height}{Numerical. Defaults to 10. Height of the plot.}

\item{text.size}{Numerical. Defaults to 12. Font size of the plot axes}

\item{return.vector}{Logical. Defaults to FALSE. If set to TRUE, it includes the vector of genes_pairs present in the dot_plot in the VDJ_GEX_matrix[[10]] list.}

\item{platypus.version}{This function works with "v3" only, there is no need to set this parameter}
}
\value{
VDJ_GEX_matrix object with output dot plot added to VDJ_GEX_matrix[[10]] list.
}
\description{
Function to cutomise the Dot Plot of CellPhoneDB analysis results.
}
\examples{
\dontrun{
vgm_cellphonedb<-dot_plot(vgm.input=vgm_cellphonedb,
selected.columns = c("group_1_3|group_2_6", "group_1_3|group_3_9", "group_2_6|group_1_3",
"group_2_6|group_3_9", "group_3_9|group_1_3", "group_3_9|group_2_6"),
threshold.type="pvalue_topn", threshold.value=50,
project.name = "test", height = 12, width=6, text.size=10, return.vector=TRUE)
}
}
