% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_GOterm.R
\name{GEX_GOterm}
\alias{GEX_GOterm}
\title{GEX GO-Term analysis and plotting}
\usage{
GEX_GOterm(
  GEX.cluster.genes.output,
  topNgenes,
  ontology,
  species,
  up.or.down,
  MT.Rb.filter,
  kegg,
  go.plots,
  top.N.go.terms.plots,
  kegg.plots,
  top.N.kegg.terms.plots
)
}
\arguments{
\item{GEX.cluster.genes.output}{Either output of Platypus::GEX_cluster_genes or custom character vector containing gene symbols. A custom gene list will not be further filtered or ordered.}

\item{topNgenes}{How many of the most significant up or down regulated genes should be considered for GO term analysis. All genes will be used if left empty.}

\item{ontology}{Ontology used for the GO terms. "MF", "BP" or "CC" possible. Default: "BP"}

\item{species}{The species the genes belong to. Default: "Mm" (requires the package "org.Mm.eg.db"). Set to "Hs" for Human (requires the package "org.Hs.eg.db")}

\item{up.or.down}{Whether up or downregulated genes should be used for GO term analysis if GEX_cluster_genes output is used. Default: "up"}

\item{MT.Rb.filter}{logical, if mitochondrial and ribosomal genes should be filtered out.}

\item{kegg}{logical, if KEGG pathway analysis should be conducted. Requires internet connection. Default: False.}

\item{go.plots}{logical, if top GO-terms should be visualized. Default: False. If True, for each cluster the  top N (top.N.GO.terms.plots) Go-terms for each cluster will be plotted to the working directory and saved as a list element. Plots are made both based on padj and ratio.}

\item{top.N.go.terms.plots}{The number of most significant GO-terms to be incluted in the go.plots. Default: 10.}

\item{kegg.plots}{logical, if top KEGG-terms should be visualized. Default: False. If True, for each cluster the  top N (top.N.kegg.terms.plots) KEGG-terms for each cluster will be plotted to the working directory and saved as a list element. Plots are made both based on padj and ratio.}

\item{top.N.kegg.terms.plots}{The number of most significant KEGG-terms to be incluted in the kegg.plots. Default: 10.}
}
\value{
Returns a list of data frames and plots containing the TopGO and the TopKEGG output containing the significant GO/KEGG terms and their visualizations.
}
\description{
Runs a GO term analysis on a submitted list of genes. Works with the output of GEX_topN_DE_genes_per_cluster or a custom list of genes to obtain GOterms.
}
\examples{
\dontrun{

GEX_GOterm(DE_genes_cluster,MT.Rb.filter = TRUE, ontology = "MF")
GEX_GOterm(rownames(DE_genes_cluster[[1]]),MT.Rb.filter = TRUE, species= "Mm",
ontology = "BP", go.plots = TRUE)

#Install the needed database with
#if (!requireNamespace("BiocManager", quietly = TRUE))
#install.packages("BiocManager")
#BiocManager::install("org.Mm.eg.db")
#BiocManager::install("org.Hs.eg.db")
}
}
