% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_isotypes_per_clone.R
\name{VDJ_isotypes_per_clone}
\alias{VDJ_isotypes_per_clone}
\title{Only for Platypus v2 Clonal frequency plot displaying the isotype usage of each clone. ! For platypus v3 use VDJ_clonal_expansion}
\usage{
VDJ_isotypes_per_clone(
  VDJ_clonotype_output,
  VDJ_per_clone_output,
  clones,
  subtypes,
  species,
  sample.names,
  treat.incomplete.clones,
  treat.incomplete.cells,
  platypus.version,
  VDJ.matrix
)
}
\arguments{
\item{VDJ_clonotype_output}{list of dataframes based on the VDJ_clonotype function output.}

\item{VDJ_per_clone_output}{list of dataframes based on the VDJ_per_clone function output.}

\item{clones}{numeric value indicating the number of clones to be displayed on the clonal expansion plot. Can take values between 1-50. Default value is 50.}

\item{subtypes}{Logical indicating whether to display isotype subtypes or not.}

\item{species}{Character indicating whether the samples are from mouse or human. Default is set to human.
#' @param sample.names Character vector with the same length of the VDJ.GEX.matrix.out list. If a VDJ table is provided, length of samples names must be one. These names are used as references to the output and as title for the plots}

\item{sample.names}{Vector. Names for samples in the order of the VDJ_GEX_matrix or the VDJ.analyze.output. Defaults to 1-n}

\item{treat.incomplete.clones}{Character indicating how to proceed with clonotypes lacking a VDJC (in other words, no cell within the clonotype has a VDJC). "exclude" removes these clonotypes from the analysis. This may result in a different frequency ranking of clonotypes than in the output of the VDJ_analyse function with filter.1HC.1LC = FALSE. "include" keeps these clonotypes in the analysis. In the plot they will appear has having an unknown isotype.}

\item{treat.incomplete.cells}{Character indicating how to proceed with cells assigned to a clonotype but missing a VDJC. "proportional" to fill in the VDJ isotype according to the proportions present in of clonotype (in case present proportions are not replicable in the total number of cells e.g. 1/3 in 10 cells, values are rounded to the next full integer and if the new counts exceed the total number of cells, 1 is subtracted from the isotype of highest frequency. If the number is below the number of cell, 1 is added to the isotype with lowest frequency to preserve diversity), "exclude" to exclude them from analysis and rank clonotypes only by the number of actual contigs of there heavy chain. This ranking may deviate from the frequency column in the clonotype table. CAVE: if treat_incomplete_cells is set to "exclude", clonotypes lacking a VDJC entierly will be removed from the analysis. This results in a similar but not identical output as when treat_incomplete_clones is set to true. The two parameters are thereby non-redundant.}

\item{platypus.version}{Defaults to "v3". For a more flexible analysis in v3 use VDJ_clonal_expansion()}

\item{VDJ.matrix}{The VDJ table output of the VDJ_GEX_matrix function. (VDJ_GEX_matrix.output[[1]])}
}
\value{
returns a list containing plots with the percentages of isotypes for each clone on the cell level.
}
\description{
Only for Platypus v2 Clonal frequency plot displaying the isotype usage of each clone. ! For platypus v3 use VDJ_clonal_expansion
}
\examples{
\dontrun{
VDJ.isotype.per.clone <- VDJ_isotypes_per_clone(
VDJ_clonotype_output = VDJ.analyze.output
,VDJ_per_clone_output = VDJ.per.clone.output, clones = 30)
}
}
