% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempar.R
\name{itempar.PlackettLuce}
\alias{itempar.PlackettLuce}
\title{Extract Item Parameters of Plackett-Luce Models}
\usage{
\method{itempar}{PlackettLuce}(object, ref = NULL, alias = TRUE,
  vcov = TRUE, log = FALSE, ...)
}
\arguments{
\item{object}{a fitted model object as returned by
\code{\link{PlackettLuce}}.}

\item{ref}{a vector of labels or position indices of item parameters which
should be used as restriction/for normalization. If \code{NULL}
(the default), all items are used with a zero sum (\code{log = TRUE}) or
unit sum (\code{log = FALSE}) constraint.}

\item{alias}{logical. If \code{TRUE} (the default), the aliased parameter is
included in the return vector (and in the variance-covariance matrix if
\code{vcov = TRUE}). If \code{FALSE}, it is removed. If the restriction given
 in ref depends on several parameters, the first parameter of the restriction
 specified is (arbitrarily) chosen to be removed if alias is \code{FALSE}.}

\item{vcov}{logical. If \code{TRUE} (the default), the (transformed)
variance-covariance matrix of the item parameters is attached as attribute
\code{vcov}. If \code{FALSE}, a \code{NA}-matrix is attached.}

\item{log}{logical. Whether to return log-abilities (\code{TRUE}) or
abilities (\code{FALSE}).}

\item{...}{further arguments which are currently not used.}
}
\value{
an object of class \code{"itempar"}, see
\code{\link[psychotools]{itempar}}.
}
\description{
A method for \code{\link[psychotools]{itempar}} to extract the item
parameters (abilities or log-abilities) from a Plackett-Luce model.
}
\examples{
R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 1, 1, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

mod <- PlackettLuce(R)
coef(mod)

# equivalent to default coefficients, i.e. log abilities
itempar(mod, ref= 1, log = TRUE)

# abilities, normalized so abilities for apple and pear sum to 1
itempar(mod, ref = 1:2)

}
