% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_pie_interactive.R
\name{geom_pie_interactive}
\alias{geom_pie_interactive}
\title{Scatter plots with interactive pie-chart glyphs}
\usage{
geom_pie_interactive(...)
}
\arguments{
\item{...}{arguments passed to \code{\link{geom_pie_glyph}}, in addition to all
\code{\link[ggiraph:interactive_parameters]{interactive_parameters}}
offered by \code{\link[ggiraph:girafe]{ggiraph}}.}
}
\value{
A ggplot layer with interactive parameters for creating ggiraph plots.
}
\description{
This geom is based on geom_pie_glyph and replaces points in a scatter plot
with interactive pie-chart glyphs to show the relative proportions of different
categories. Like geom_pie_glyph, the pie-chart glyphs are independent of the
axes, with the additional feature of being interactive and can be hovered over
to show information about the raw counts of the different categories. The
interactivity is  added using the \code{\link[ggiraph:girafe]{ggiraph}}
framework and all features offered by \code{\link[ggiraph:girafe]{ggiraph}}
are supported.
}
\examples{
#' ## Load libraries
library(dplyr)
library(tidyr)
library(ggplot2)
library(ggiraph)

## Simulate raw data
set.seed(123)
plot_data <- data.frame(response = rnorm(10, 100, 30),
                        system = as.factor(1:10),
                        group = sample(size = 10,
                                       x = c("G1", "G2", "G3"),
                                       replace = TRUE),
                        A = round(runif(10, 3, 9), 2),
                        B = round(runif(10, 1, 5), 2),
                        C = round(runif(10, 3, 7), 2),
                        D = round(runif(10, 1, 9), 2))

head(plot_data)

# One of the interactive aesthetics is tooltip. It is set that by default
# it shows the value and percentage of each slice in the pie-chart.
# Hover over any pie-chart in the plot to see this
plot_obj1 <- ggplot(data = plot_data, aes(x = system, y = response)) +
               geom_pie_interactive(slices = c("A", "B", "C", "D"),
                                    data = plot_data)+
               theme_classic()
x1 <- girafe(ggobj = plot_obj1)
if(interactive()) print(x1)

# The user can also set their own custom tooltip which could either by
# a column in the data or a custom string
plot_obj2 <- ggplot(data = plot_data, aes(x = system, y = response)) +
               # Setting the group as a tooltip
               geom_pie_interactive(slices = c("A", "B", "C", "D"),
                                    data = plot_data,
                                    aes(tooltip = paste0("Group: ", group)))+
               theme_classic()
x2 <- girafe(ggobj = plot_obj2)
if(interactive()) print(x2)

# It is also possible to add an identifier to highlight all elements within
# a group when one element of a group is hovered over by using data_id
plot_obj3 <- ggplot(data = plot_data, aes(x = system, y = response)) +
               # Setting the group as a tooltip
               geom_pie_interactive(slices = c("A", "B", "C", "D"),
                                    data = plot_data, colour = "black",
                                    aes(data_id = group))+
               theme_classic()
x3 <- girafe(ggobj = plot_obj3)
# Hover over one pie-glyph to highlight all observations within the same group
if(interactive()) print(x3)

# All other aesthetics and attributes of geom_pie_glyph can be used as well
}
\seealso{
\code{\link[ggiraph:girafe]{girafe()}}, \code{\link[=geom_pie_glyph]{geom_pie_glyph()}}
}
