% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumVct.R
\name{sumVct}
\alias{sumVct}
\title{Summarize Wear and Nonwear Time Interval}
\usage{
sumVct(datavct, wearing = "wearing", TS = getOption("pa.timeStamp"),
  markingString = "w", by = "days", id = NULL)
}
\arguments{
\item{datavct}{Data with classified wear (nonwear) status classified by
\code{\link{wearingMarking}}.}

\item{wearing}{The column name for classified wear and nonwear status. The
default is "wearing".}

\item{TS}{The column name for timestamp. The default is "TimeStamp".}

\item{markingString}{Option for summarizing wear (markingString="w") or
nonwear time interval (markingString="nw").}

\item{by}{A sequence of days for classified wear (nonwear) time intervals.}

\item{id}{Optional output for subject identification or file name.}
}
\value{
The summary data for wear and nonwear time intervals.
}
\description{
This function summarizes the classified wear (nonwear) time by interval basis
from the epoch-by-epoch classified wear (nonwear) status classified by
\code{\link{wearingMarking}}.
}
\examples{

data(dataSec)

mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)

data1m = wearingMarking(dataset = mydata1m,
                       frame = 90, 
                       perMinuteCts = 1,
                       TS = "TimeStamp",
                       cts = "counts", 
                       streamFrame = NULL, 
                       allowanceFrame= 2, 
                       newcolname = "wearing")

sumVct(data1m, id="sdata1m")
sumVct(data1m, id="sdata1m", markingString = "nw")
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\seealso{
\code{\link{wearingMarking}}, \code{\link{summaryData}}
}
\author{
Leena Choi \email{leena.choi@Vanderbilt.Edu},
Cole Beck \email{cole.beck@vumc.org},
Zhouwen Liu \email{zhouwen.liu@vumc.org},
Charles E. Matthews \email{Charles.Matthews2@nih.gov}, and
Maciej S. Buchowski \email{maciej.buchowski@Vanderbilt.Edu}
}
