% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPSet.R
\name{downloadPSet}
\alias{downloadPSet}
\title{Download a PharmacoSet object}
\usage{
downloadPSet(name, saveDir = file.path(".", "PSets"), myfn = NULL,
  verbose = TRUE)
}
\arguments{
\item{name}{\code{Character} string, the name of the PhamracoSet to download.
The available options are CGP, CCLE, and CMAP}

\item{saveDir}{\code{Character} string with the folder path where the
PharmacoSet should be saved. Defaults to \code{'./PSets/'}. Will create
directory if it does not exist.}

\item{myfn}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status messages be printed during download.
Defaults to TRUE.}
}
\value{
A PSet object with the dataset, downloaded from our server
}
\description{
This function allows you to download a \code{PharmacoSet} object for use with this
package. The \code{PharmacoSets} have been extensively curated and organised within
a PharacoSet class, enabling use with all the analysis tools provided in
\code{PharmacoGx}.
}

