% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drugPerturbationSig.R
\name{drugPertubrationSig}
\alias{drugPertubrationSig}
\title{Creates a signature representing gene expression (or other molecular profile)
change induced by administrating a drug, for use in drug effect analysis.}
\usage{
drugPertubrationSig(pSet, molecularData = c("rna", "dna", "snp", "cnv"),
  drugs, nbcore = 1, returnValues = c("estimate", "tstat", "pvalue", "fdr"),
  verbose = FALSE)
}
\arguments{
\item{pSet}{\code{PharmacoSet} of the perturbation experiment type}

\item{molecularData}{\code{character} string, which one of the molecular data
types to use in the analysis, out of DNA, RNA, SNP, CNV}

\item{drugs}{\code{character} vector of drug names for which to compute the
signatures. Should match the names used in the PharmacoSet.}

\item{nbcore}{\code{numeric}, if multiple cores are available, how many cores
should the computation be parallelized over?}

\item{returnValues}{\code{character} vector, identifying which of estimate,
t-stat, p-value and fdr should the function return for each gene drug pair?}

\item{verbose}{\code{bool} Should the function print diagnostic messages?
Defaults to FALSE}
}
\value{
A 3D \code{array} with genes in the first dimension, drugs in the
  second, and return values in the third.
}
\description{
Given a Pharmacoset of the perturbation experiment type, and a list of drugs,
the function will compute a signature for the effect of drug concentration on
the molecular profile of a cell. The algorithm uses a regression model which
corrects for experimental batch effects, cell specific differences, and
duration of experiment to isolate the effect of the concentration of the drug
applied. The function returns the estimated coefficient for concentration,
the t-stat, the p-value and the false discovery rate associated with that
coefficient, in a 3 dimensional array, with genes in the first direction,
drugs in the second, and the selected return values in the third.
}
\examples{
data(CMAPsmall)
drug.perturbation <- drugPertubrationSig(CMAPsmall)
head(drug.perturbation)
}

