% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{breeds}
\alias{breeds}
\title{Returns breed names of specified animal type, or types.}
\usage{
breeds(types, return_df = TRUE)
}
\arguments{
\item{types}{Specifies the animal type or types. Can be a character vector representing a single animal type, or a 
vector or list of animal types if more than one type is desired.If not specified, all available breeds for each animal type is returned. The animal type must be of 'dog', 'cat', 'rabbit', 'small-furry', 'horse', 'bird', 'scales-fins-other', 'barnyard'.}

\item{return_df}{If TRUE, the result set will be coerced into a pandas data.frame with two columns, breed and name.}
}
\value{
List of returned JSON data of available breeds for each specified animal type from the Petfinder API. If the parameter return_df 
  is TRUE, a data.frame is returned instead.
}
\description{
Returns breed names of specified animal type, or types.
}
\examples{
\dontrun{
pf <- Petfinder(key=key, secret=secret) # Initialize Petfinder class
cat_breeds <- pf$breeds('cat')
cat_dog_breeds <- pf$breeds(c('cat', 'dog'))
all_breeds <- pf$breeds()
all_breeds_df <- pf$breeds(return_df=TRUE)
}
}
