% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_wae_is_long}
\alias{data_wae_is_long}
\title{Walleye data with incomplete stratification with length covariate}
\format{
\code{data_wae_is_long}
A data frame with many rows and 3 columns

\describe{
\item{\code{cap_hist}.}{Capture history with possible histories as noted below}
\item{\code{freq}.}{Number of fish with this history.}
\item{\code{length}}{Length of fish (inches)}
}
}
\usage{
data(data_wae_is_long)
}
\description{
Data used in
Premarathna, W.A.L., Schwarz, C.J., Jones, T.S. (2018)
Partial stratification in two-sample capture–recapture experiments.
Environmetrics, 29:e2498. https://doi.org/10.1002/env.2498
}
\details{
Fish were tagged on the spawning grounds and
recovered in the summer gillnet assessment.

Length was measured a both times and didn't not change
very much between the two sampling occasions. The value
recorded below is the average of the two lengths if both
lengths were present.

Rather than sexing all of the fish, only a sub-sample of unmarked fish
is sexed at each sampling occasion. Possible capture histories are then
M0, F0, MM, FF, U0, UU, 0M, 0F
}
\keyword{datasets}
