% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitivity.R
\name{transitivity}
\alias{transitivity}
\title{calculate transitivity measurements for a matrix}
\usage{
transitivity(conf, strict = FALSE)
}
\arguments{
\item{conf}{an N-by-N conflict matrix whose \code{(i,j)}th element is the number of times \code{i} defeated \code{j}}

\item{strict}{a logical vector of length 1 (TRUE or FALSE). It is used in transitivity definition for alpha estimation. 
It should be set to TRUE when a transitive triangle is defined as all pathways in the triangle go to the same direction;
it should be set to FALSE when a transitive triangle is defined as PRIMARY pathways in the triangle go to the same direction.
Strict = FALSE by default.}
}
\value{
A list of four elements.

 \item{transitive}{The number of transitive triangles.}
 
 \item{intransitive}{The number of intransitive triangles.}
 
 \item{transitivity}{transitivity, the proportion of transitive triangles.}
 
 \item{alpha}{The value of alpha corresponding to this value of transitivity.}
}
\description{
\code{transitivity} calculate transitivity measurements for a matrix
}
\details{
\code{transitivity} is calculated as the proportion transitive triangles in the total of transitive and intransitive triangles.
transitivity is used to estimate alpha, which is used in turn in imputing information from indirect pathways as to what degree we can trust information from indirect pathways.
Greater transitivity is associated with assigning higher weight to information from indirect pathways.
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# transitivity calculation
conftrans <- transitivity(confmatrix, strict = FALSE)
conftrans$transitive
conftrans$intransitive
conftrans$transitivity
conftrans$alpha
}
\seealso{
\code{\link{countPaths}}, \code{\link{findIDpaths}}, \code{\link{conductance}}
}

