% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw.R
\name{mw}
\alias{mw}
\title{Compute the molecular weight of a protein sequence}
\source{
The formula and amino acid scale are the same available on ExPASy Compute pI/Mw tool: http://web.expasy.org/compute_pi/
}
\usage{
mw(seq, monoisotopic = FALSE)
}
\arguments{
\item{seq}{An amino-acids sequence}

\item{monoisotopic}{A logical value \code{'TRUE'} or \code{'FALSE'} indicating if monoisotopic weights of amino-acids should be used}
}
\description{
This function calculates the molecular weight of a protein sequence. It is calculated as the sum of the mass of each amino acid using the scale available on Compute pI/Mw tool.
}
\details{
The molecular weight is the sum of the masses of each atom constituting a molecule. The molecular weight is directly related to the length of the amino acid sequence and is expressed in units called daltons (Da). In Peptides the function mw computes the molecular weight using the same formulas and weights as ExPASy's "compute pI/mw" tool (Gasteiger et al., 2005).
}
\examples{
# COMPARED TO ExPASy Compute pI/Mw tool
# http://web.expasy.org/compute_pi/
# SEQUENCE: QWGRRCCGWGPGRRYCVRWC 
# Theoretical pI/Mw: 9.88 / 2485.91 

mw(seq = "QWGRRCCGWGPGRRYCVRWC",monoisotopic = FALSE)
# [1] 2485.911

mw(seq = "QWGRRCCGWGPGRRYCVRWC",monoisotopic = TRUE)
# [1] 2484.12
}
\references{
Gasteiger, E., Hoogland, C., Gattiker, A., Wilkins, M. R., Appel, R. D., & Bairoch, A. (2005). Protein identification and analysis tools on the ExPASy server. In The proteomics protocols handbook (pp. 571-607). Humana Press. Chicago
}
