% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boman.R
\name{boman}
\alias{boman}
\title{Compute the Boman (Potential Protein Interaction) index}
\usage{
boman(seq)
}
\arguments{
\item{seq}{An amino-acid sequence}
}
\value{
The computed potential protein-protein interaction for a given amino-acids sequence
}
\description{
This function computes the potential protein interaction index proposed by Boman (2003) based in the amino acid sequence of a protein. 
The index is equal to the sum of the solubility values for all residues in a sequence, it might give an overall estimate of the potential of a peptide to bind to membranes or other proteins as receptors, to normalize it is divided by the number of residues. 
A protein have high binding potential if the index value is higher than 2.48.
}
\details{
The potential protein interaction index was proposed by Boman (2003) as an easy way to differentiate the action mechanism of hormones (protein-protein) and antimicrobial peptides (protein-membrane) through this index. This function predicts the potential peptide interaction with another protein.
}
\examples{
# COMPARED TO YADAMP DATABASE
# http://yadamp.unisa.it/showItem.aspx?yadampid=845&x=0,4373912
# SEQUENCE: FLPVLAGLTPSIVPKLVCLLTKKC
# BOMAN INDEX  -1.24  

boman("FLPVLAGLTPSIVPKLVCLLTKKC")
# [1] -1.235833

}
\references{
Boman, H. G. (2003). Antibacterial peptides: basic facts and emerging concepts. Journal of Internal Medicine, 254(3), 197-215.
}
