% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CRE.R
\name{CRE}
\alias{CRE}
\title{A Model with Correlated Random Effects in Poisson and Probit Equations}
\usage{
CRE(sel_form, out_form, id, data = NULL, par = NULL, par_files = NULL,
  delta = 1, sigma = 1, rho = 0, lower = c(rho = -1), upper = c(rho =
  1), method = "L-BFGS-B", H = c(10, 10), psnH = 20, prbH = 20,
  accu = 1e+10, verbose = 0)
}
\arguments{
\item{sel_form}{Formula for selection equation, a probit model with random effects}

\item{out_form}{Formula for outcome equation, a Poisson model with random effects}

\item{id}{A vector that represents the identity of individuals, numeric or character}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{par_files}{Loading initial values from saved ProbitRE and PoissonRE estimates}

\item{delta}{Variance of random effects in Probit model}

\item{sigma}{Variance of random effects in Poisson model}

\item{rho}{Correlation between random effects in Probit and Poisson models}

\item{lower}{Lower bound for estiamtes}

\item{upper}{Upper bound for estimates}

\item{method}{Searching algorithm, don't change default unless you know what you are doing}

\item{H}{A vector of length 2, specifying the number of points for inner and outer Quadratures}

\item{psnH}{Number of Quadrature points for Poisson RE model}

\item{prbH}{Number of Quddrature points for Probit RE model}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{verbose}{Level of output during estimation. Lowest is 0.}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a model in panel counting data, in which the selection equation is a Probit model with random effects on individuals, and the outcome equation is a Poisson model with random effects on the same individuals. The random effects on the same individual are correlated across two equations.
}
\examples{
data(rt)
est = CRE(isRetweet~fans+tweets+as.factor(tweet.id),
                   num.words~fans+tweets+as.factor(tweet.id),
                   id=rt$user.id, data=rt)
}
\seealso{
Other PanelCount: \code{\link{CRE_SS}};
  \code{\link{PLN_RE}}; \code{\link{PoissonRE}};
  \code{\link{ProbitRE}}
}

