% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CRE_SS.R
\name{CRE_SS}
\alias{CRE_SS}
\title{A Sample Selection Model with Correlated Random Effects}
\usage{
CRE_SS(sel_form, out_form, id, data = NULL, par = NULL, par_files = NULL,
  delta = 1, sigma = 1, gamma = 1, rho = 0, tau = 0, lower = c(rho =
  -1, tau = -1), upper = c(rho = 1, tau = 1), method = "L-BFGS-B",
  H = c(10, 10), psnH = 20, prbH = 20, plnreH = 20, accu = 1e+10,
  verbose = 0)
}
\arguments{
\item{sel_form}{Formula for selection equation, a probit model with random effects}

\item{out_form}{Formula for outcome equation, a Poisson model with random effects}

\item{id}{A vector that represents the identity of individuals, numeric or character}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{par_files}{Loading initial values from saved ProbitRE and PoissonRE estimates}

\item{delta}{Variance of random effects on the individual level for ProbitRE}

\item{sigma}{Variance of random effects on the individual level for PLN_RE}

\item{gamma}{Variance of random effects on the <individual, time> level for PLN_RE}

\item{rho}{Correlation between random effects on the individual level}

\item{tau}{Correlation between error terms on the <individual, time> level}

\item{lower}{Lower bound for estiamtes}

\item{upper}{Upper bound for estimates}

\item{method}{Searching algorithm, don't change default unless you know what you are doing}

\item{H}{A vector of length 2, specifying the number of points for inner and outer Quadratures}

\item{psnH}{Number of Quadrature points for Poisson RE model}

\item{prbH}{Number of Quddrature points for Probit RE model}

\item{plnreH}{Number of Quddrature points for PLN_RE model}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{verbose}{Level of output during estimation. Lowest is 0.}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a sample selection model in panel counting data, in which the selection equation is a Probit model with random effects on individuals, and the outcome equation is a Poisson Lognormal model with random effects on the same individuals. The random effects on the same individual and the error terms on the same <individual, time> dyad are both correlated across two equations.
}
\examples{
\donttest{
data(rt)
est = CRE_SS(isRetweet~fans+tweets+as.factor(tweet.id),
                       num.words~fans+tweets+as.factor(tweet.id),
                       id=rt$user.id, data=rt)
}
}
\seealso{
Other PanelCount: \code{\link{CRE}}; \code{\link{PLN_RE}};
  \code{\link{PoissonRE}}; \code{\link{ProbitRE}}
}

