% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-getData.R
\name{loadData}
\alias{loadData}
\title{Load Data}
\usage{
loadData(
  path,
  type = c("xlsx", "xls", "odt", "csv", "txt"),
  nrows = NA_integer_,
  sep = ",",
  dec = ".",
  fileEncoding = "",
  colNames = TRUE,
  sheet = 1,
  verbose = TRUE
)
}
\arguments{
\item{path}{path to the file}

\item{type}{(character) type of file, one of \code{c("xlsx", "xls", "odt", "csv", "txt")}}

\item{nrows}{integer: the maximum number of rows to read in.  Negative
    and other invalid values are ignored.}

\item{sep}{the field separator character.  Values on each line of the
    file are separated by this character.  If \code{sep = ""} (the
    default for \code{read.table}) the separator is \sQuote{white space},
    that is one or more spaces, tabs, newlines or carriage returns.}

\item{dec}{the character used in the file for decimal points.}

\item{fileEncoding}{character string: if non-empty declares the
    encoding used on a file (not a connection) so the character data can
    be re-encoded.  See the \sQuote{Encoding} section of the help for
    \code{\link{file}}, the \sQuote{R Data Import/Export} manual and
    \sQuote{Note}.
  }

\item{colNames}{If \code{TRUE}, the first row of data will be used as column names.}

\item{sheet}{The name or index of the sheet to read data from.}

\item{verbose}{Logical, indicating whether to display processing messages.
If TRUE, messages will be displayed; if FALSE, messages will be suppressed.
Default is TRUE.}
}
\value{
(data.frame) data loaded from the file at path
}
\description{
Load Data
}
