% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PakPC2017Punjab.R
\docType{data}
\name{PakPC2017Punjab}
\alias{PakPC2017Punjab}
\title{Punjab Province data from Pakistan Population Census 2017}
\format{A \code{data.table} and  \code{data.frame} with 72 obs. of  12 variables.}
\usage{
data(PakPC2017Punjab)
}
\description{
\code{PakPC2017Punjab} Punjab Province data from Pakistan Population Census 2017.
}
\details{
\itemize{
       \item Province Province of Pakistan
       \item Division Division of Punjab Province of Pakitan
       \item District District of Punjab Province of Pakitan
       \item ResStatus Residental Status
       \item Households No. of Households
       \item Male Male Population
       \item Female Female Population
       \item Transgender Transgender Population
       \item Pop2017 Total Population in 2017
       \item Pop1998 Total Population in 1998
       \item SexRatio2017 Sex Ration accoring to Pakistan Population Census 2017
       \item GrowthRate 1998-2017 Average Annual Growth Rate
       }
}
\examples{
data(PakPC2017Punjab)
library(data.table)
PakPC2017Res <- 
          c(
              "Households", "Male", "Female", "Transgender"
            , "Pop2017", "Pop1998", "SexRatio2017", "GrowthRate"
            )


PakPC2017Punjab[
       , j        = lapply(.SD, sum, na.rm = TRUE) 
       , by       = .(Division, District)
       , .SDcols  = PakPC2017Res
       ][order(Division, District)]

}
\references{
\enumerate{
\item Pakistan Population Census 2017 (\url{http://www.pbscensus.gov.pk/}).
 }
}
\seealso{
, \code{\link{PakPC2017Balochistan}}
   \code{\link{PakPC2017City10}}
 , \code{\link{PakPC2017FATA}}
 , \code{\link{PakPC2017Islamabad}}
 , \code{\link{PakPC2017KPK}}
 , \code{\link{PakPC2017Pak}}
 , \code{\link{PakPC2017Pakistan}}
 , \code{\link{PakPC2017Sindh}}
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
\keyword{datasets}
