% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_extractDataFrame.R
\name{monitor_extractDataFrame}
\alias{monitor_extractDataFrame}
\alias{monitor_extractData}
\alias{monitor_extractMeta}
\title{Extract dataframes from \emph{ws_monitor} objects}
\usage{
monitor_extractData(ws_monitor)

monitor_extractMeta(ws_monitor)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object to extract dataframe from.}
}
\value{
A dataframe from the given \emph{ws_monitor} object
}
\description{
These functions are convenient wrappers for extracting the dataframes that
comprise a \emph{ws_monitor} object. These functions are designed to be
useful when manipulating data in a pipe chain.

Below is a table showing equivalent operations for each function.

\tabular{ll}{
  \strong{Function} \tab \strong{Equivalent Operation}\cr
  \code{monitor_extractData(ws_monitor)} \tab \code{ws_monitor[["data"]]}\cr
  \code{monitor_extractMeta(ws_monitor)} \tab \code{ws_monitor[["meta"]]}
}
}
\examples{
\dontrun{
ws_monitor <- Northwest_Megafires

NMData <- ws_monitor \%>\%
  monitor_subset(
    stateCodes = "WA",
    tlim = c(20150801, 20150831)
  ) \%>\%
  extract_data()

monitor_subset(
    stateCodes = "WA",
    tlim = c(20150801, 20150831)
  ) \%>\%
  extract_meta()
}

}
