% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqiPalette.R
\name{aqiPalette}
\alias{aqiPalette}
\title{Color Palettes for Air Quality Monitoring Data}
\usage{
aqiPalette(style = "aqi", reverse = FALSE)
}
\arguments{
\item{style}{Palette style, one of `aqi`.}

\item{reverse}{Logicial specifying whether the colors (or color function) in
palette should be used in reverse order.}
}
\value{
A function that takes a single parameter x; when called with a vector
of numbers, #RRGGBB color strings are returned.
}
\description{
Creates a *leaflet* color palette function that can be used
to convert monitoring data into vectors of colors.
}
\examples{
pm25 <- PWFSLSmoke::Carmel_Valley$data[,2]
binned_colors <- aqiPalette("aqi")(pm25)
plot(pm25, col=binned_colors, pch=15, main='Binned Colors')
}
\seealso{
`leaflet::colorBin()`
}
