% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqiColors.R
\name{aqiColors}
\alias{aqiColors}
\title{Generate AQI Colors}
\usage{
aqiColors(x, palette = AQI$colors, domain = c(0, 1e+06),
  bins = AQI$breaks_24, na.color = NA)
}
\arguments{
\item{x}{vector or matrix of PM2.5 values or a \emph{ws_monitor} object}

\item{palette}{color palette (see \code{leaflet::colorBin()})}

\item{domain}{range of valid data (see \code{leaflet::colorBin()})}

\item{bins}{color bins (see \code{leaflet::colorBin()})}

\item{na.color}{missing value color (see \code{leaflet::colorBin()})}
}
\value{
A vector or matrix of AQI colors to be used in maps and plots.
}
\description{
This function uses the \code{leaflet::colorBin()} function
to return a vector or matrix of colors derived from PM2.5 values.
}
\examples{
wa <- monitor_subset(Northwest_Megafires, stateCodes='WA', tlim=c(20150821,20150828))
colorMatrix <- aqiColors(wa)
time <- wa$data$datetime
pm25 <- wa$data[,-1]
plot(time, pm25[,1], col=colorMatrix[,1],
     ylim=range(pm25, na.rm=TRUE),
     xlab="2015", ylab="PM 2.5 (ug/m3)", main="Washington State Smoke")
for ( i in 1:ncol(pm25) ) {
  points(time, pm25[,i], col=colorMatrix[,i], pch=16)
}
}
\keyword{plotting}
\keyword{ws_monitor}
