% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorPlot_dailyBarplot.R
\name{monitorPlot_dailyBarplot}
\alias{monitorPlot_dailyBarplot}
\title{Create Daily Barplot}
\usage{
monitorPlot_dailyBarplot(ws_monitor, monitorID = NULL, tlim = NULL,
  minHours = 18, gridPos = "", gridCol = "black", gridLwd = 0.5,
  gridLty = "solid", labels_x_nudge = 0, labels_y_nudge = 0, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{monitorID}{monitor ID for a specific monitor in \code{ws_monitor} (optional
if \code{ws_monitor} only has one monitor)}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{minHours}{minimum number of valid data hours required to calculate each daily average}

\item{gridPos}{position of grid lines either 'over', 'under' ('' for no grid lines)}

\item{gridCol}{color of grid lines (see graphical parameter 'col')}

\item{gridLwd}{line width of grid lines (see graphical parameter 'lwd')}

\item{gridLty}{type of grid lines (see graphical parameter 'lty')}

\item{labels_x_nudge}{nudge x labels to the left}

\item{labels_y_nudge}{nudge y labels down}

\item{...}{additional arguments to be passed to \code{barplot()}}
}
\description{
Creates a bar plot showing daily average PM 2.5 values for a specific monitor
in a \emph{ws_monitor} object. Each bar is colored according to its AQI category.

This function is a wrapper around \code{base::barplot} and any arguments to that 
function may be used.

Each 'day' is the midnight-to-midnight period in the monitor local timezone.
When \code{tlim} is used, it is converted to the monitor local timezone.
}
\details{
The \code{labels_x_nudge} and \code{labels_y_nudge} can be used to 
tweak the date labeling. Units used are the same as those in the plot.
}
\examples{
\dontrun{
N_M <- monitor_subset(Northwest_Megafires, tlim=c(20150715,20150930))
main <- "Daily Average PM2.5 for Omak, WA"
monitorPlot_dailyBarplot(N_M, monitorID="530470013", main=main,
                         labels_x_nudge=1)
addAQILegend(fill=rev(AQI$colors), pch=NULL)
}
}
\keyword{ws_monitor}
