% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_load.R
\name{wrcc_load}
\alias{wrcc_load}
\title{Load Processed WRCC Monitoring Data}
\usage{
wrcc_load(year = 2017,
  baseUrl = "https://haze.airfire.org/monitoring/WRCC/RData/")
}
\arguments{
\item{year}{desired year (integer or character representing YYYY)}

\item{baseUrl}{base URL for WRCC meta and data files}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Loads pre-generated .RData files containing WRCC PM2.5 data.

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/WRCC/RData/}{https://haze.airfire.org/monitoring/WRCC/RData/}
}
\examples{
\dontrun{
wrcc <- wrcc_load(2017)
wrcc_conus <- monitor_subset(wrcc, stateCodes=CONUS)
monitorLeaflet(wrcc_conus)
}
}
\seealso{
\code{\link{wrcc_loadDaily}}

\code{\link{wrcc_loadLatest}}
}
\keyword{WRCC}
