% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_downloadData.R
\name{epa_downloadData}
\alias{epa_downloadData}
\title{Download Data from EPA}
\usage{
epa_downloadData(year = NULL, parameterCode = "88101",
  downloadDir = tempdir(), baseUrl = "https://aqs.epa.gov/aqsweb/airdata/")
}
\arguments{
\item{year}{year}

\item{parameterCode}{pollutant code}

\item{downloadDir}{directoroy where monitoring data .zip file will be saved}

\item{baseUrl}{base URL for archived daily data}
}
\value{
Filepath of the downloaded zip file.
}
\description{
This function downloads air quality data from the EPA and
saves it to a directory.

Available parameter codes include:
\enumerate{
\item{44201}{ -- Ozone}
\item{42401}{ -- SO2}
\item{42101}{ -- CO}
\item{42602}{ -- NO2}
\item{88101}{ -- PM2.5}
\item{88502}{ -- PM2.5}
\item{81102}{ -- PM10}
\item{SPEC}{ -- PM2.5}
\item{WIND}{ -- Wind}
\item{TEMP}{ -- Temperature}
\item{PRESS}{ -- Barometric Pressure}
\item{RH_DP}{ -- RH and dewpoint}
\item{HAPS}{ -- HAPs}
\item{VOCS}{ -- VOCs}
\item{NONOxNOy}
}
}
\note{
Unzipped CSV files are almost 100X larger than the compressed .zip files.
}
\examples{
\dontrun{
zipFile <- epa_downloadData(2016, "88101", '~/Data/EPA')
tbl <- epa_parseData(zipFile, "PM2.5")
}
}
\references{
\href{https://aqs.epa.gov/aqsweb/airdata/download_files.html#Raw}{EPA AirData Pre-Generated Data Files}
}
\keyword{EPA}
