% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_createMonitorObject.R
\name{airsis_createMonitorObject}
\alias{airsis_createMonitorObject}
\title{Obain AIRSIS Data and Create ws_monitor Object}
\usage{
airsis_createMonitorObject(startdate = 20020101,
  enddate = strftime(lubridate::now(), "\%Y\%m\%d", tz = "GMT"),
  provider = NULL, unitID = NULL, clusterDiameter = 1000,
  baseUrl = "http://xxxx.airsis.com/vision/common/CSVExport.aspx?",
  saveFile = NULL)
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{provider}{identifier used to modify baseURL \code{['APCD'|'USFS']}}

\item{unitID}{character or numeric AIRSIS unit identifier}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering})}

\item{baseUrl}{base URL for data queries}

\item{saveFile}{optional filename where raw CSV will be written}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Obtains monitor data from an AIRSIS webservice and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{download CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape AIRSIS data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}
}
\note{
The downloaded CSV may be saved to a local file by providing an argument to the \code{saveFile} parameter.
}
\examples{
\dontrun{
usfs_1013 <- airsis_createMonitorObject(20150301, 20150831, 'USFS', unitID='1013')
monitorLeaflet(usfs_1013)
}
}
\seealso{
\code{\link{airsis_downloadData}}

\code{\link{airsis_parseData}}

\code{\link{airsis_qualityControl}}

\code{\link{addClustering}}

\code{\link{airsis_createMetaDataframe}}

\code{\link{airsis_createDataDataframe}}
}
\keyword{AIRSIS}

