% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilldeboerLM.R
\name{hilldeboer.LM}
\alias{hilldeboer.LM}
\title{Hill-Deboer Isotherm Linear Analysis}
\usage{
hilldeboer.LM(theta, Ce, Temp)
}
\arguments{
\item{theta}{is the fractional surface coverage}

\item{Ce}{the numerical value for the equilibrium capacity}

\item{Temp}{temperature}
}
\value{
the linear regression, parameters for the Hill-Deboer isotherm,
and model error analysis
}
\description{
Hill-Deboer isotherm model describes as a case where there is
mobile adsorption as well as lateral interaction among molecules.The increased
or decreased affinity depends on the kind of force among the adsorption molecules.
If there is an attraction between adsorbed molecules, there is an increase in
affinity. On the other hand, decreased affinity happens when there is repulsion
among the adsorbed molecules.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607,
0.80435, 1.10327, 1.58223)
theta  <- c(0.1972984, 0.3487013, 0.6147560, 0.7432401, 0.8854408,
0.8900708, 0.9106746, 0.9106746, 0.9611422)
Temp <- 298.15
hilldeboer.LM(theta, Ce, Temp)
}
\references{
De Boer, J. H. (1953). The Dynamical Character of adsorption,
Oxford University Press, Oxford, England.

Foo, K. Y., &amp; Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
