% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_computeQC.R
\name{createReport}
\alias{createReport}
\title{Create a quality control report (in PDF format).}
\usage{
createReport(txt_folder, yaml_obj = list(), report_filenames = NULL)
}
\arguments{
\item{txt_folder}{Path to txt output folder of MaxQuant (e.g. "c:/data/Hek293/txt")}

\item{yaml_obj}{A nested list object with configuration parameters for the report.
Useful to switch off certain plots or skip entire sections.}

\item{report_filenames}{Optional list with names (as generated by \code{\link{getReportFilenames}}). 
If not provided, will be created internally by calling \code{\link{getReportFilenames}}.}
}
\value{
List with named filename strings, e.g. $yaml_file, $report_file etc..
}
\description{
This is the main function of the package and the only thing you need to call directly if you are 
just interested in getting a QC report.
}
\details{
You need to provide the folder name of the 'txt' output, as generated by MaxQuant and 
optionally a YAML configuration object, which allows to (de)activate certain plots and holds other parameters.
The yaml_obj is complex and best obtained by running this function once using the default (empty list).
A full YAML configuration object will be written in the 'txt' folder you provide and can be loaded using
\code{\link[yaml]{yaml.load}}.

The PDF and the config file will be stored in the given txt folder.
}
\note{
You need write access to the txt folder!

For updates, bug fixes and feedback please visit \url{http://github.com/cbielow/PTXQC}.
}

